/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst28EventLayout;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class UstDebugInfoStateProvider
extends AbstractTmfStateProvider {
    public static final String MEMSZ_ATTRIB = "memsz";
    public static final String PATH_ATTRIB = "path";
    public static final String IS_PIC_ATTRIB = "is_pic";
    public static final String BUILD_ID_ATTRIB = "build_id";
    public static final String DEBUG_LINK_ATTRIB = "debug_link";
    private static final int VERSION = 4;
    private static final Logger LOGGER = TraceCompassLog.getLogger(UstDebugInfoStateProvider.class);
    private static final int DL_DLOPEN_INDEX = 1;
    private static final int DL_BUILD_ID_INDEX = 2;
    private static final int DL_DEBUG_LINK_INDEX = 3;
    private static final int DL_DLCLOSE_INDEX = 4;
    private static final int STATEDUMP_BIN_INFO_INDEX = 5;
    private static final int STATEDUMP_BUILD_ID_INDEX = 6;
    private static final int STATEDUMP_DEBUG_LINK_INDEX = 7;
    private static final int STATEDUMP_START_INDEX = 8;
    private final LttngUst28EventLayout fLayout;
    private final Map<String, Integer> fEventNames;
    private final Map<Pair<Long, Long>, PendingBinInfo> fPendingBinInfos = new HashMap<Pair<Long, Long>, PendingBinInfo>();

    public UstDebugInfoStateProvider(LttngUstTrace trace) {
        super((ITmfTrace)trace, "Ust:DebugInfo");
        ILttngUstEventLayout layout = trace.getEventLayout();
        if (!(layout instanceof LttngUst28EventLayout)) {
            throw new IllegalStateException("Debug info analysis was started with an incompatible trace.");
        }
        this.fLayout = (LttngUst28EventLayout)layout;
        this.fEventNames = UstDebugInfoStateProvider.buildEventNames(this.fLayout);
    }

    private static Map<String, Integer> buildEventNames(LttngUst28EventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventDlOpen(), (Object)1);
        builder.put((Object)layout.eventDlBuildId(), (Object)2);
        builder.put((Object)layout.eventDlDebugLink(), (Object)3);
        builder.put((Object)layout.eventDlClose(), (Object)4);
        builder.put((Object)layout.eventStatedumpBinInfo(), (Object)5);
        builder.put((Object)layout.eventStateDumpBuildId(), (Object)6);
        builder.put((Object)layout.eventStateDumpDebugLink(), (Object)7);
        builder.put((Object)layout.eventStatedumpStart(), (Object)8);
        return builder.build();
    }

    protected void eventHandle(ITmfEvent event) {
        Long vpid = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.contextVpid()});
        if (vpid == null) {
            return;
        }
        @NonNull ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        String name = event.getName();
        Integer index = this.fEventNames.get(name);
        if (index == null) {
            return;
        }
        int intIndex = index;
        switch (intIndex) {
            case 8: {
                UstDebugInfoStateProvider.handleStatedumpStart(event, vpid, ss);
                break;
            }
            case 1: 
            case 5: {
                this.handleOpen(event, vpid, ss);
                break;
            }
            case 2: 
            case 6: {
                this.handleBuildId(event, vpid, ss);
                break;
            }
            case 3: 
            case 7: {
                this.handleDebugLink(event, vpid, ss);
                break;
            }
            case 4: {
                this.handleClose(event, vpid, ss);
                break;
            }
        }
    }

    private static void commitPendingToStateSystem(PendingBinInfo pending, long ts, ITmfStateSystemBuilder ss) {
        if (!pending.done()) {
            throw new IllegalStateException();
        }
        long vpid = pending.fVpid;
        long baddr = pending.fBaddr;
        long memsz = pending.fMemsz;
        String path = pending.fPath;
        String buildId = pending.getBuildId();
        String debugLink = pending.getDebugLink();
        boolean isPIC = pending.fIsPIC;
        int baddrQuark = ss.getQuarkAbsoluteAndAdd(new String[]{Long.toString(vpid), Long.toString(baddr)});
        int memszQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{MEMSZ_ATTRIB});
        int pathQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{PATH_ATTRIB});
        int isPICQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{IS_PIC_ATTRIB});
        int buildIdQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{BUILD_ID_ATTRIB});
        int debugLinkQuark = ss.getQuarkRelativeAndAdd(baddrQuark, new String[]{DEBUG_LINK_ATTRIB});
        try {
            ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueInt((int)1), baddrQuark);
            ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueLong((long)memsz), memszQuark);
            ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueString((String)path), pathQuark);
            ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueInt((int)(isPIC ? 1 : 0)), isPICQuark);
            if (buildId != null) {
                ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueString((String)buildId), buildIdQuark);
            } else {
                ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.nullValue(), buildIdQuark);
            }
            if (debugLink != null) {
                ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueString((String)debugLink), debugLinkQuark);
            } else {
                ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.nullValue(), debugLinkQuark);
            }
        }
        catch (StateValueTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    private @Nullable PendingBinInfo retrievePendingBinInfo(long vpid, long baddr) {
        Pair key = new Pair((Object)vpid, (Object)baddr);
        return this.fPendingBinInfos.remove(key);
    }

    private void processPendingBinInfo(PendingBinInfo pending, long ts, ITmfStateSystemBuilder ss) {
        if (pending.done()) {
            UstDebugInfoStateProvider.commitPendingToStateSystem(pending, ts, ss);
        } else {
            Pair key = new Pair((Object)pending.fVpid, (Object)pending.fBaddr);
            this.fPendingBinInfos.put((Pair<Long, Long>)key, pending);
        }
    }

    private static void handleStatedumpStart(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) {
        try {
            long ts = event.getTimestamp().getValue();
            int vpidQuark = ss.getQuarkAbsolute(new String[]{vpid.toString()});
            ss.removeAttribute(ts, vpidQuark);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    private void handleOpen(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) {
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        Long memsz = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldMemsz()});
        String path = (String)event.getContent().getFieldValue(String.class, new String[]{this.fLayout.fieldPath()});
        Long hasBuildIdValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldHasBuildId()});
        Long hasDebugLinkValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldHasDebugLink()});
        Long isPicValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldIsPic()});
        if (baddr == null || memsz == null || path == null || hasBuildIdValue == null || hasDebugLinkValue == null) {
            LOGGER.warning(() -> "[UstDebugInfoStateProvider:InvalidDlOpenEvent] event=" + event.toString());
            return;
        }
        boolean isPic = true;
        if (isPicValue != null) {
            isPic = isPicValue != 0L;
        }
        boolean hasBuildId = hasBuildIdValue != 0L;
        boolean hasDebugLink = hasDebugLinkValue != 0L;
        long ts = event.getTimestamp().getValue();
        PendingBinInfo p = new PendingBinInfo(hasBuildId, hasDebugLink, vpid, baddr, memsz, path, isPic);
        this.processPendingBinInfo(p, ts, ss);
    }

    private void handleBuildId(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) {
        long[] buildIdArray = (long[])event.getContent().getFieldValue(long[].class, new String[]{this.fLayout.fieldBuildId()});
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        if (buildIdArray == null || baddr == null) {
            LOGGER.warning(() -> "[UstDebugInfoStateProvider:InvalidBuildIdEvent] event=" + event.toString());
            return;
        }
        String buildId = (String)NonNullUtils.checkNotNull((Object)BaseEncoding.base16().encode(UstDebugInfoStateProvider.longArrayToByteArray(buildIdArray)).toLowerCase());
        long ts = event.getTimestamp().getValue();
        PendingBinInfo p = this.retrievePendingBinInfo(vpid, baddr);
        if (p == null) {
            return;
        }
        p.setBuildId(buildId);
        this.processPendingBinInfo(p, ts, ss);
    }

    private void handleDebugLink(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) {
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        String debugLink = (String)event.getContent().getFieldValue(String.class, new String[]{this.fLayout.fieldDebugLinkFilename()});
        if (baddr == null || debugLink == null) {
            LOGGER.warning(() -> "[UstDebugInfoStateProvider:InvalidDebugLinkEvent] event=" + event.toString());
            return;
        }
        long ts = event.getTimestamp().getValue();
        PendingBinInfo pendingBinInfo = this.retrievePendingBinInfo(vpid, baddr);
        if (pendingBinInfo == null) {
            return;
        }
        pendingBinInfo.setDebugLink(debugLink);
        this.processPendingBinInfo(pendingBinInfo, ts, ss);
    }

    private void handleClose(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) {
        Long baddr = (Long)event.getContent().getFieldValue(Long.class, new String[]{this.fLayout.fieldBaddr()});
        if (baddr == null) {
            LOGGER.warning(() -> "[UstDebugInfoStateProvider:InvalidDlCloseEvent] event=" + event.toString());
            return;
        }
        try {
            int quark = ss.getQuarkAbsolute(new String[]{vpid.toString(), baddr.toString()});
            long ts = event.getTimestamp().getValue();
            ss.removeAttribute(ts, quark);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    private static byte[] longArrayToByteArray(long[] array) {
        byte[] ret = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            ret[i] = (byte)array[i];
            ++i;
        }
        return ret;
    }

    public ITmfStateProvider getNewInstance() {
        return new UstDebugInfoStateProvider(this.getTrace());
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public int getVersion() {
        return 4;
    }

    private class PendingBinInfo {
        private final long fVpid;
        private final long fBaddr;
        private final long fMemsz;
        private final String fPath;
        private final boolean fIsPIC;
        private @Nullable String fBuildId = null;
        private @Nullable String fDebugLink = null;
        private boolean fBuildIdPending;
        private boolean fDebugLinkPending;

        public PendingBinInfo(boolean hasBuildId, boolean hasDebugLink, long vpid, long baddr, long memsz, String path, boolean isPIC) {
            this.fVpid = vpid;
            this.fBaddr = baddr;
            this.fMemsz = memsz;
            this.fPath = path;
            this.fIsPIC = isPIC;
            this.fBuildIdPending = hasBuildId;
            this.fDebugLinkPending = hasDebugLink;
        }

        boolean done() {
            return !this.fBuildIdPending && !this.fDebugLinkPending;
        }

        public void setBuildId(String buildId) {
            this.fBuildIdPending = false;
            this.fBuildId = buildId;
        }

        public @Nullable String getBuildId() {
            return this.fBuildId;
        }

        public void setDebugLink(String debugLink) {
            this.fDebugLinkPending = false;
            this.fDebugLink = debugLink;
        }

        public @Nullable String getDebugLink() {
            return this.fDebugLink;
        }
    }
}

