/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;

public final class FileOffsetMapper {
    private static final Logger LOGGER = TraceCompassLog.getLogger(FileOffsetMapper.class);
    private static final String DISCRIMINATOR = "\\(discriminator.*\\)";
    private static final String ADDR2LINE_EXECUTABLE = "addr2line";
    private static final long CACHE_SIZE = 1000L;
    private static final String UNKNOWN_VALUE = "??";
    private static final LoadingCache<FileOffset, @NonNull Iterable<Addr2lineInfo>> ADDR2LINE_INFO_CACHE = (LoadingCache)NonNullUtils.checkNotNull((Object)CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<FileOffset, Iterable<Addr2lineInfo>>(){

        public @NonNull Iterable<Addr2lineInfo> load(FileOffset fo) {
            LOGGER.fine(() -> "[FileOffsetMapper:CacheMiss] file/offset=" + fo.toString());
            return FileOffsetMapper.callAddr2line(fo);
        }
    }));

    private FileOffsetMapper() {
    }

    public static @Nullable TmfCallsite getCallsiteFromOffset(File file, @Nullable String buildId, long offset) {
        Iterable<Addr2lineInfo> output = FileOffsetMapper.getAddr2lineInfo(file, buildId, offset);
        if (output == null || Iterables.isEmpty(output)) {
            return null;
        }
        Addr2lineInfo info = (Addr2lineInfo)Iterables.getLast(output);
        String sourceFile = info.fSourceFileName;
        Long sourceLine = info.fSourceLineNumber;
        if (sourceFile == null) {
            return null;
        }
        return new TmfCallsite(sourceFile, sourceLine);
    }

    public static @Nullable String getFunctionNameFromOffset(File file, @Nullable String buildId, long offset) {
        Iterable<Addr2lineInfo> output = FileOffsetMapper.getAddr2lineInfo(file, buildId, offset);
        if (output == null || Iterables.isEmpty(output)) {
            return null;
        }
        Addr2lineInfo info = (Addr2lineInfo)Iterables.getLast(output);
        return info.fFunctionName;
    }

    private static @Nullable Iterable<Addr2lineInfo> getAddr2lineInfo(File file, @Nullable String buildId, long offset) {
        LOGGER.finer(() -> String.format("[FileOffsetMapper:Addr2lineRequest] file=%s, buildId=%s, offset=0x%h", file.toString(), buildId, offset));
        if (!Files.exists(file.toPath(), new LinkOption[0])) {
            LOGGER.finer(() -> "[FileOffsetMapper:RequestFailed] File not found");
            return null;
        }
        FileOffset fo = new FileOffset((String)NonNullUtils.checkNotNull((Object)file.toString()), buildId, offset);
        @Nullable Iterable callsites = (Iterable)ADDR2LINE_INFO_CACHE.getUnchecked((Object)fo);
        LOGGER.finer(() -> String.format("[FileOffsetMapper:RequestComplete] callsites=%s", callsites));
        return callsites;
    }

    private static Iterable<Addr2lineInfo> callAddr2line(FileOffset fo) {
        String filePath = fo.fFilePath;
        long offset = fo.fOffset;
        LinkedList<Addr2lineInfo> callsites = new LinkedList<Addr2lineInfo>();
        List<String> output = FileOffsetMapper.getOutputFromCommand(Arrays.asList(ADDR2LINE_EXECUTABLE, "-i", "-f", "-C", "-e", filePath, "0x" + Long.toHexString(offset)));
        if (output == null) {
            return Collections.EMPTY_SET;
        }
        boolean oddLine = false;
        String currentFunctionName = null;
        for (String outputLine : output) {
            Long lineNumber;
            oddLine = !oddLine;
            outputLine = outputLine.replaceFirst(DISCRIMINATOR, "").trim();
            if (oddLine) {
                if (outputLine.equals(UNKNOWN_VALUE)) {
                    currentFunctionName = null;
                    continue;
                }
                currentFunctionName = outputLine;
                continue;
            }
            String[] elems = outputLine.split(":");
            String fileName = elems[0];
            if (fileName.equals(UNKNOWN_VALUE)) {
                fileName = null;
            }
            try {
                lineNumber = Long.valueOf(elems[1]);
            }
            catch (NumberFormatException e) {
                lineNumber = null;
            }
            callsites.add(new Addr2lineInfo(fileName, currentFunctionName, lineNumber));
        }
        return callsites;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable List<String> getOutputFromCommand(List<String> command) {
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process p = builder.start();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                int ret = p.waitFor();
                List<String> lines = br.lines().collect(Collectors.toList());
                return ret == 0 ? lines : null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
    }

    private static class Addr2lineInfo {
        private final @Nullable String fSourceFileName;
        private final @Nullable Long fSourceLineNumber;
        private final @Nullable String fFunctionName;

        public Addr2lineInfo(@Nullable String sourceFileName, @Nullable String functionName, @Nullable Long sourceLineNumber) {
            this.fSourceFileName = sourceFileName;
            this.fSourceLineNumber = sourceLineNumber;
            this.fFunctionName = functionName;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("fSourceFileName", (Object)this.fSourceFileName).add("fSourceLineNumber", (Object)this.fSourceLineNumber).add("fFunctionName", (Object)this.fFunctionName).toString();
        }
    }

    private static class FileOffset {
        private final String fFilePath;
        private final @Nullable String fBuildId;
        private final long fOffset;

        public FileOffset(String filePath, @Nullable String buildId, long offset) {
            this.fFilePath = filePath;
            this.fBuildId = buildId;
            this.fOffset = offset;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.fFilePath, this.fBuildId, this.fOffset});
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileOffset other = (FileOffset)obj;
            return Objects.equal((Object)this.fFilePath, (Object)other.fFilePath) && Objects.equal((Object)this.fBuildId, (Object)other.fBuildId) && Objects.equal((Object)this.fOffset, (Object)other.fOffset);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("fFilePath", (Object)this.fFilePath).add("fBuildId", (Object)this.fBuildId).add("fOffset", (Object)String.format("0x%h", this.fOffset)).toString();
        }
    }
}

