/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.PageLayout;
import org.eclipse.cdt.ui.wizards.CDTMainWizardPage;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.cdt.ui.wizards.conversion.ConvertProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ConvertToMakeWizardPage
extends ConvertProjectWizardPage {
    private static final String WZ_TITLE = "WizardMakeProjectConversion.title";
    private static final String WZ_DESC = "WizardMakeProjectConversion.description";
    protected CWizardHandler h_selected = null;
    private Button specifyProjectTypeButton;
    private Tree tree;
    private Composite right;
    private Button show_sup;
    private Label right_label;
    private Label left_label;

    public ConvertToMakeWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IStructuredSelection sel = ((BasicNewResourceWizard)this.getWizard()).getSelection();
        if (sel != null) {
            this.tableViewer.setCheckedElements(sel.toArray());
            this.setPageComplete(this.validatePage());
        }
    }

    protected void addToMainPage(Composite container) {
        super.addToMainPage(container);
        Group optionsGroup = new Group(container, 0);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 200;
        optionsGroup.setLayoutData((Object)layoutData);
        optionsGroup.setLayout((Layout)new GridLayout(1, true));
        optionsGroup.setText(MakeUIPlugin.getResourceString((String)"WizardMakeProjectConversion.projectOptions.title"));
        Composite c = new Composite((Composite)optionsGroup, 0);
        c.setLayoutData((Object)new GridData(1808));
        c.setLayout((Layout)new GridLayout(2, true));
        this.specifyProjectTypeButton = new Button(c, 32);
        this.specifyProjectTypeButton.setText(MakeUIPlugin.getResourceString((String)"WizardMakeProjectConversion.projectOptions.projectType"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.specifyProjectTypeButton.setLayoutData((Object)gd);
        this.specifyProjectTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertToMakeWizardPage.this.enableProjectTypeControls(ConvertToMakeWizardPage.this.specifyProjectTypeButton.getSelection());
            }
        });
        this.left_label = new Label(c, 0);
        this.left_label.setText(MakeUIPlugin.getResourceString((String)"WizardMakeProjectConversion.projectOptions.projectTypeTable"));
        this.left_label.setFont(container.getFont());
        this.left_label.setLayoutData((Object)new GridData(1));
        this.right_label = new Label(c, 0);
        this.right_label.setFont(container.getFont());
        this.right_label.setLayoutData((Object)new GridData(1));
        this.tree = new Tree(c, 2052);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] tis = ConvertToMakeWizardPage.this.tree.getSelection();
                if (tis == null || tis.length == 0) {
                    return;
                }
                ConvertToMakeWizardPage.this.switchTo((CWizardHandler)tis[0].getData(), (EntryDescriptor)tis[0].getData("EntryDescriptor"));
            }
        });
        this.right = new Composite(c, 0);
        this.right.setLayoutData((Object)new GridData(1808));
        this.right.setLayout((Layout)new PageLayout());
        this.show_sup = new Button(c, 32);
        this.show_sup.setSelection(true);
        this.show_sup.setText(MakeUIPlugin.getResourceString((String)"WizardMakeProjectConversion.projectOptions.showSuppressed"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.show_sup.setLayoutData((Object)gd);
        final IWizardItemsListListener filter = new IWizardItemsListListener(){

            public List<EntryDescriptor> filterItems(List<? extends EntryDescriptor> items) {
                ArrayList<EntryDescriptor> results = new ArrayList<EntryDescriptor>();
                for (EntryDescriptor entryDescriptor : items) {
                    if (!entryDescriptor.isCategory()) continue;
                    results.add(entryDescriptor);
                }
                return results;
            }

            public boolean isCurrent() {
                return true;
            }

            public void toolChainListChanged(int count) {
            }
        };
        this.show_sup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConvertToMakeWizardPage.this.h_selected != null) {
                    ConvertToMakeWizardPage.this.h_selected.setSupportedOnly(ConvertToMakeWizardPage.this.show_sup.getSelection());
                }
                ConvertToMakeWizardPage.this.switchTo(CDTMainWizardPage.updateData((Tree)ConvertToMakeWizardPage.this.tree, (Composite)ConvertToMakeWizardPage.this.right, (Button)ConvertToMakeWizardPage.this.show_sup, (IWizardItemsListListener)filter, null), CDTMainWizardPage.getDescriptor((Tree)ConvertToMakeWizardPage.this.tree));
            }
        });
        CDTPrefUtil.readPreferredTCs();
        this.switchTo(CDTMainWizardPage.updateData((Tree)this.tree, (Composite)this.right, (Button)this.show_sup, (IWizardItemsListListener)filter, null), CDTMainWizardPage.getDescriptor((Tree)this.tree));
        this.specifyProjectTypeButton.setSelection(true);
        this.enableProjectTypeControls(true);
    }

    private void enableProjectTypeControls(boolean enabled) {
        this.left_label.setEnabled(enabled);
        this.right_label.setEnabled(enabled);
        this.tree.setEnabled(enabled);
        this.right.setEnabled(enabled);
        this.enabledCompositeChildren(this.right, enabled);
        this.show_sup.setEnabled(enabled);
    }

    private void enabledCompositeChildren(Composite composite, boolean enabled) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enabled);
            if (children[i] instanceof Composite) {
                this.enabledCompositeChildren((Composite)children[i], enabled);
            }
            ++i;
        }
    }

    private void switchTo(CWizardHandler h, EntryDescriptor ed) {
        if (h == null) {
            h = ed.getHandler();
        }
        try {
            if (h != null && ed != null) {
                h.initialize(ed);
            }
        }
        catch (CoreException e) {
            h = null;
        }
        if (this.h_selected != null) {
            this.h_selected.handleUnSelection();
        }
        this.h_selected = h;
        if (h == null) {
            return;
        }
        this.right_label.setText(this.h_selected.getHeader());
        this.h_selected.handleSelection();
        this.h_selected.setSupportedOnly(this.show_sup.getSelection());
    }

    protected String getWzTitleResource() {
        return MakeUIPlugin.getResourceString((String)WZ_TITLE);
    }

    protected String getWzDescriptionResource() {
        return MakeUIPlugin.getResourceString((String)WZ_DESC);
    }

    public boolean isCandidate(IProject project) {
        boolean isCDTProject = AbstractPage.isCDTPrj((IProject)project);
        boolean cOnly = false;
        try {
            cOnly = !project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException e) {
            return false;
        }
        return !isCDTProject || cOnly;
    }

    public void convertProject(IProject project, String bsId, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(MakeUIPlugin.getResourceString((String)"WizardMakeProjectConversion.monitor.convertingToMakeProject"), 3);
        try {
            boolean wasCDTProject = AbstractPage.isCDTPrj((IProject)project);
            super.convertProject(project, bsId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!wasCDTProject && this.isSetProjectType()) {
                this.h_selected.convertProject(project, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        monitor.beginTask(MakeUIPlugin.getResourceString((String)"WizardMakeProjectConversion.monitor.convertingToMakeProject"), 3);
        try {
            boolean wasCDTProject = AbstractPage.isCDTPrj((IProject)project);
            super.convertProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1), projectID);
            if (!wasCDTProject && this.isSetProjectType()) {
                this.h_selected.convertProject(project, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isSetProjectType() {
        return this.specifyProjectTypeButton != null && this.specifyProjectTypeButton.getSelection();
    }
}

