/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.token;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class EmailLinkReplacementToken
extends PatternBasedElement {
    private static final String EMAIL_PATTERN = "([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,}))";

    protected String getPattern(int groupOffset) {
        return EMAIL_PATTERN;
    }

    protected int getPatternGroupCount() {
        return 4;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new EmailLinkReplacementTokenProcessor();
    }

    private static class EmailLinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private EmailLinkReplacementTokenProcessor() {
        }

        public void emit() {
            String text = this.group(1);
            String href = "mailto:" + text;
            this.builder.link((Attributes)new LinkAttributes(), href, text);
        }
    }
}

