/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractCLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final String EMPTY_STR = "";
    private IProject project;
    private List orderedProjects;
    private String preLaunchBuildConfiguration;
    private boolean workspaceBuildBeforeLaunch;
    private boolean buildFailed;

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new CLaunch(configuration, mode, null);
    }

    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    @Deprecated
    public File getWorkingDir(ILaunchConfiguration configuration) throws CoreException {
        return this.getWorkingDirectory(configuration);
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return this.verifyWorkingDirectory(configuration);
    }

    protected IPath getWorkingDirectoryPath(ILaunchConfiguration config) throws CoreException {
        String expandedLocation;
        String location = config.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = LaunchUtils.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            return new Path(expandedLocation);
        }
        return null;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus(this.getPluginID(), code, message, exception);
            multiStatus.add((IStatus)new Status(4, this.getPluginID(), code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, this.getPluginID(), code, message, null);
        }
        throw new CoreException((IStatus)status);
    }

    protected void cancel(String message, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(0, this.getPluginID(), code, message, null));
    }

    protected abstract String getPluginID();

    @Deprecated
    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        return CDebugUtils.getCProject((ILaunchConfiguration)configuration);
    }

    @Deprecated
    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return CDebugUtils.getProjectName((ILaunchConfiguration)configuration);
    }

    @Deprecated
    public static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return CDebugUtils.getProgramName((ILaunchConfiguration)configuration);
    }

    @Deprecated
    public static IPath getProgramPath(ILaunchConfiguration configuration) throws CoreException {
        return CDebugUtils.getProgramPath((ILaunchConfiguration)configuration);
    }

    @Deprecated
    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration config) throws CoreException {
        this.setDefaultSourceLocator(launch, config);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                ICProject cProject = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
                if (cProject == null) {
                    this.abort(LaunchMessages.Launch_common_Project_does_not_exist, null, 103);
                }
                sourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    public String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.getProgramArguments(config);
    }

    public String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.getProgramArgumentsArray(config);
    }

    protected String renderProcessLabel(String commandLine) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format((String)format, (Object[])new Object[]{commandLine, timestamp});
    }

    @Deprecated
    protected String renderDebuggerProcessLabel() {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format((String)format, (Object[])new Object[]{LaunchMessages.AbstractCLaunchDelegate_Debugger_Process, timestamp});
    }

    @Deprecated
    protected IFile getProgramFile(ILaunchConfiguration config) throws CoreException {
        IFile programPath;
        ICProject cproject = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        String fileName = CDebugUtils.getProgramName((ILaunchConfiguration)config);
        if (fileName == null) {
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Program_file_not_specified, null, 105);
        }
        if ((programPath = ((IProject)cproject.getResource()).getFile(fileName)) == null || !programPath.exists() || !programPath.getLocation().toFile().exists()) {
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Program_file_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_PROGRAM_PATH_not_found, (Object)programPath.getLocation().toOSString())), 104);
        }
        return programPath;
    }

    @Deprecated
    protected ICProject verifyCProject(ILaunchConfiguration config) throws CoreException {
        return CDebugUtils.verifyCProject((ILaunchConfiguration)config);
    }

    @Deprecated
    protected IPath verifyProgramPath(ILaunchConfiguration config) throws CoreException {
        return CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
    }

    protected IPath verifyProgramFile(ILaunchConfiguration config) throws CoreException {
        return this.getProgramFile(config).getLocation();
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            ICProject cp = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
            if (cp != null) {
                IProject p = cp.getProject();
                return p.getLocation().toFile();
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Working_directory_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_WORKINGDIRECTORY_PATH_not_found, (Object)path.toOSString())), 101);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(LaunchMessages.AbstractCLaunchDelegate_Working_directory_does_not_exist, new FileNotFoundException(NLS.bind((String)LaunchMessages.AbstractCLaunchDelegate_WORKINGDIRECTORY_PATH_not_found, (Object)path.toOSString())), 101);
        }
        return null;
    }

    private void getReferencedProjectSet(IProject proj, HashSet referencedProjSet) throws CoreException {
        IProject[] projects = proj.getReferencedProjects();
        int i = 0;
        while (i < projects.length) {
            IProject refProject = projects[i];
            if (refProject.exists() && !referencedProjSet.contains(refProject)) {
                referencedProjSet.add(refProject);
                this.getReferencedProjectSet(refProject, referencedProjSet);
            }
            ++i;
        }
    }

    private List getBuildOrder(List resourceCollection) {
        String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (orderedNames != null) {
            ArrayList<Object> orderedProjs = new ArrayList<Object>(resourceCollection.size());
            ArrayList unorderedProjects = new ArrayList(resourceCollection.size());
            unorderedProjects.addAll(resourceCollection);
            int i = 0;
            while (i < orderedNames.length) {
                String projectName = orderedNames[i];
                int j = 0;
                while (j < resourceCollection.size()) {
                    IProject proj = (IProject)resourceCollection.get(j);
                    if (proj.getName().equals(projectName)) {
                        orderedProjs.add(proj);
                        unorderedProjects.remove(proj);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            orderedProjs.addAll(unorderedProjects);
            return orderedProjs;
        }
        IProject[] projects = new IProject[resourceCollection.size()];
        projects = resourceCollection.toArray(projects);
        IWorkspace.ProjectOrder po = ResourcesPlugin.getWorkspace().computeProjectOrder(projects);
        ArrayList<IProject> orderedProjs = new ArrayList<IProject>();
        orderedProjs.addAll(Arrays.asList(po.projects));
        return orderedProjs;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.workspaceBuildBeforeLaunch = true;
        int buildBeforeLaunchValue = configuration.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2);
        if (buildBeforeLaunchValue == 0) {
            return false;
        }
        if (this.orderedProjects == null) {
            return false;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int scale = 1000;
        int totalWork = (this.orderedProjects.size() + 1) * scale;
        try {
            monitor.beginTask(LaunchMessages.AbstractCLaunchDelegate_building_projects, totalWork);
            try {
                for (IProject proj : this.orderedProjects) {
                    monitor.subTask(String.valueOf(LaunchMessages.AbstractCLaunchDelegate_building) + proj.getName());
                    proj.build(10, (IProgressMonitor)new LaunchUtils.BuildProgressMonitor(monitor, scale));
                }
                monitor.subTask(String.valueOf(LaunchMessages.AbstractCLaunchDelegate_building) + this.project.getName());
                this.setBuildConfiguration(configuration, this.project);
                this.project.build(10, (IProgressMonitor)new LaunchUtils.BuildProgressMonitor(monitor, scale));
            }
            catch (Exception e) {
                this.buildFailed = true;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private void setBuildConfiguration(ILaunchConfiguration configuration, IProject buildProject) {
        try {
            ICConfigurationDescription buildConfiguration;
            ICProjectDescription projDes = CDTPropertyManager.getProjectDescription((IProject)buildProject);
            String buildConfigID = null;
            if (configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", false)) {
                String programPath = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STR);
                programPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programPath);
                ICConfigurationDescription buildConfig = LaunchUtils.getBuildConfigByProgramPath(buildProject, programPath);
                if (buildConfig != null) {
                    buildConfigID = buildConfig.getId();
                }
            } else {
                buildConfigID = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", EMPTY_STR);
            }
            if (buildConfigID != null && buildConfigID.length() > 0 && projDes != null && (buildConfiguration = projDes.getConfigurationById(buildConfigID)) != null) {
                this.preLaunchBuildConfiguration = projDes.getActiveConfiguration().getId();
                buildConfiguration.setActive();
                CDTPropertyManager.performOk(null);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!this.workspaceBuildBeforeLaunch && 1 == configuration.getAttribute("org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", 2)) {
            try {
                LaunchUtils.BuildProgressMonitor buildMonitor = new LaunchUtils.BuildProgressMonitor(monitor, 10, 4);
                buildMonitor.beginTask(LaunchMessages.AbstractCLaunchDelegate_BuildBeforeLaunch, 10);
                buildMonitor.subTask(LaunchMessages.AbstractCLaunchDelegate_PerformingBuild);
                if (this.buildForLaunch(configuration, mode, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)buildMonitor, 7))) {
                    buildMonitor.subTask(LaunchMessages.AbstractCLaunchDelegate_PerformingIncrementalBuild);
                    ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)buildMonitor, 3));
                } else {
                    buildMonitor.worked(3);
                }
            }
            catch (Exception e) {
                this.buildFailed = true;
            }
        }
        boolean continueLaunch = true;
        if (this.orderedProjects == null) {
            return continueLaunch;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int scale = 1000;
        int totalWork = (this.orderedProjects.size() + 1) * scale;
        try {
            IStatusHandler prompter;
            monitor.beginTask(LaunchMessages.AbstractCLaunchDelegate_searching_for_errors, totalWork);
            boolean compileErrorsInProjs = this.buildFailed;
            if (!compileErrorsInProjs) {
                for (IProject proj : this.orderedProjects) {
                    monitor.subTask(String.valueOf(LaunchMessages.AbstractCLaunchDelegate_searching_for_errors_in) + proj.getName());
                    monitor.worked(scale);
                    compileErrorsInProjs = this.existsErrors(proj);
                    if (compileErrorsInProjs) break;
                }
            }
            if (!compileErrorsInProjs) {
                monitor.subTask(String.valueOf(LaunchMessages.AbstractCLaunchDelegate_searching_for_errors_in) + this.project.getName());
                monitor.worked(scale);
                compileErrorsInProjs = this.existsErrors(this.project);
            }
            if (compileErrorsInProjs && (prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus)) != null) {
                continueLaunch = (Boolean)prompter.handleStatus(complileErrorPromptStatus, null);
            }
        }
        finally {
            monitor.done();
        }
        if (continueLaunch) {
            this.resetBuildConfiguration(this.project);
        }
        return continueLaunch;
    }

    private void resetBuildConfiguration(IProject buildProject) {
        if (this.preLaunchBuildConfiguration != null) {
            ICConfigurationDescription buildConfiguration;
            ICProjectDescription projDes = CDTPropertyManager.getProjectDescription((IProject)buildProject);
            if (this.preLaunchBuildConfiguration.length() > 0 && projDes != null && (buildConfiguration = projDes.getConfigurationById(this.preLaunchBuildConfiguration)) != null) {
                buildConfiguration.setActive();
                CDTPropertyManager.performOk(null);
            }
        }
        this.preLaunchBuildConfiguration = null;
    }

    protected boolean existsErrors(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers.length > 0) {
            int j = 0;
            while (j < markers.length) {
                Object severityAttribute = markers[j].getAttribute("severity");
                if (severityAttribute != null && (Integer)severityAttribute == 2) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!mode.equals("run")) {
            LaunchUtils.enableActivity("org.eclipse.cdt.debug.cdigdbActivity", true);
        }
        this.workspaceBuildBeforeLaunch = false;
        int scale = 1000;
        int totalWork = 2 * scale;
        try {
            monitor.beginTask(LaunchMessages.AbstractCLaunchDelegate_20, totalWork);
            this.orderedProjects = null;
            ICProject cProject = CDebugUtils.getCProject((ILaunchConfiguration)configuration);
            if (cProject != null) {
                this.project = cProject.getProject();
                HashSet projectSet = new HashSet();
                this.getReferencedProjectSet(this.project, projectSet);
                this.orderedProjects = this.getBuildOrder(new ArrayList(projectSet));
            }
            monitor.worked(scale);
            boolean bl = super.preLaunchCheck(configuration, mode, (IProgressMonitor)new SubProgressMonitor(monitor, scale));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    protected IBinaryParser.IBinaryObject verifyBinary(ICProject proj, IPath exePath) throws CoreException {
        try {
            return LaunchUtils.getBinary(proj.getProject(), exePath);
        }
        catch (ClassCastException e) {
            ClassCastException exception = e;
            Status status = new Status(4, this.getPluginID(), 107, String.valueOf(LaunchMessages.AbstractCLaunchDelegate_Program_is_not_a_recognized_executable) + " " + exePath.toOSString(), (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
    }

    protected Properties getEnvironmentAsProperty(ILaunchConfiguration config) throws CoreException {
        String[] envp = this.getEnvironment(config);
        Properties p = new Properties();
        int i = 0;
        while (i < envp.length) {
            int idx = envp[i].indexOf(61);
            if (idx != -1) {
                String key = envp[i].substring(0, idx);
                String value = envp[i].substring(idx + 1);
                p.setProperty(key, value);
            } else {
                p.setProperty(envp[i], EMPTY_STR);
            }
            ++i;
        }
        return p;
    }

    protected String[] getEnvironment(ILaunchConfiguration config) throws CoreException {
        try {
            Map map = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            if (map != null) {
                wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, map);
                wc.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
                config = wc.doSave();
            }
            boolean append = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_INHERIT", true);
            wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, append);
        }
        catch (CoreException map) {
            // empty catch block
        }
        String[] array = DebugPlugin.getDefault().getLaunchManager().getEnvironment(config);
        if (array == null) {
            return new String[0];
        }
        return array;
    }

    @Deprecated
    protected String[] getEnvironmentArray(ILaunchConfiguration config) {
        Map env = null;
        try {
            env = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (env == null) {
            return new String[0];
        }
        String[] array = new String[env.size()];
        Iterator entries = env.entrySet().iterator();
        int i = 0;
        while (entries.hasNext() && i < array.length) {
            Map.Entry entry = entries.next();
            array[i] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
            ++i;
        }
        return array;
    }

    @Deprecated
    protected Properties getEnvironmentProperty(ILaunchConfiguration config) {
        Properties prop = new Properties();
        Map env = null;
        try {
            env = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (env == null) {
            return prop;
        }
        for (Map.Entry entry : env.entrySet()) {
            prop.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return prop;
    }

    protected Map getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, "C/C++");
        return map;
    }

    public class CLaunch
    extends Launch {
        private final AtomicBoolean fRefreshDone;

        public CLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
            super(launchConfiguration, mode, locator);
            this.fRefreshDone = new AtomicBoolean(false);
        }

        public void refresh() {
            if (this.fRefreshDone.compareAndSet(false, true)) {
                final ILaunchConfiguration config = this.getLaunchConfiguration();
                try {
                    if (RefreshTab.getRefreshScope((ILaunchConfiguration)config) != null) {
                        Job refreshJob = new Job(LaunchMessages.AbstractCLaunchDelegate_Refresh){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    RefreshTab.refreshResources((ILaunchConfiguration)config, (IProgressMonitor)monitor);
                                }
                                catch (CoreException e) {
                                    return new Status(4, "org.eclipse.cdt.launch", 1, e.getLocalizedMessage(), (Throwable)e);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        refreshJob.setSystem(true);
                        refreshJob.schedule();
                    }
                }
                catch (CoreException e) {
                    LaunchUIPlugin.log(e.getStatus());
                }
            }
        }
    }
}

