/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlameGraphContentProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlameGraphPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.SortOption;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

public class FlameGraphView
extends TmfView {
    public static final String ID = String.valueOf(FlameGraphView.class.getPackage().getName()) + ".flamegraphView";
    private static final String SORT_OPTION_KEY = "sort.option";
    private static final ImageDescriptor SORT_BY_NAME_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha.gif");
    private static final ImageDescriptor SORT_BY_NAME_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha_rev.gif");
    private static final ImageDescriptor SORT_BY_ID_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num.gif");
    private static final ImageDescriptor SORT_BY_ID_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num_rev.gif");
    private TimeGraphViewer fTimeGraphViewer;
    private FlameGraphContentProvider fTimeGraphContentProvider;
    private TimeGraphPresentationProvider fPresentationProvider;
    private ITmfTrace fTrace;
    private final @NonNull MenuManager fEventMenuManager = new MenuManager();
    private Action fSortByNameAction;
    private Action fSortByIdAction;

    public FlameGraphView() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        ITmfTrace trace;
        super.createPartControl(parent);
        this.fTimeGraphViewer = new TimeGraphViewer(parent, 0);
        this.fTimeGraphContentProvider = new FlameGraphContentProvider();
        this.fPresentationProvider = new FlameGraphPresentationProvider();
        this.fTimeGraphViewer.setTimeGraphContentProvider((ITimeGraphContentProvider)this.fTimeGraphContentProvider);
        this.fTimeGraphViewer.setTimeGraphProvider((ITimeGraphPresentationProvider)this.fPresentationProvider);
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.contributeToActionBars();
        this.loadSortOption();
        this.getSite().setSelectionProvider(this.fTimeGraphViewer.getSelectionProvider());
        this.createTimeEventContextMenu();
    }

    @TmfSignalHandler
    public void TraceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        if (this.fTrace != null) {
            CallGraphAnalysis flamegraphModule = (CallGraphAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)this.fTrace, CallGraphAnalysis.class, (String)"org.eclipse.tracecompass.internal.analysis.timing.ui.callgraph.callgraphanalysis");
            this.buildFlameGraph(flamegraphModule);
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.fTrace = signal.getTrace();
        if (this.fTrace != null) {
            CallGraphAnalysis flamegraphModule = (CallGraphAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)this.fTrace, CallGraphAnalysis.class, (String)"org.eclipse.tracecompass.internal.analysis.timing.ui.callgraph.callgraphanalysis");
            this.buildFlameGraph(flamegraphModule);
        }
    }

    private void buildFlameGraph(final CallGraphAnalysis callGraphAnalysis) {
        this.fTimeGraphViewer.setInput(null);
        callGraphAnalysis.schedule();
        Job j = new Job(Messages.CallGraphAnalysis_Execution){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                callGraphAnalysis.waitForCompletion(monitor);
                Display.getDefault().asyncExec(() -> {
                    FlameGraphView.this.fTimeGraphViewer.setInput((Object)callGraphAnalysis.getThreadNodes());
                    FlameGraphView.this.fTimeGraphViewer.resetStartFinishTime();
                });
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.fTimeGraphViewer.setInput(null);
        }
    }

    public void setFocus() {
        this.fTimeGraphViewer.setFocus();
    }

    private void createTimeEventContextMenu() {
        this.fEventMenuManager.setRemoveAllWhenShown(true);
        final TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        final Menu timeEventMenu = this.fEventMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeGraphEntryMenuListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        timeGraphControl.addTimeEventMenuListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                Menu menu = timeEventMenu;
                if (event.data instanceof FlamegraphEvent) {
                    timeGraphControl.setMenu(menu);
                    return;
                }
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        this.fEventMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FlameGraphView.this.fillTimeEventContextMenu((IMenuManager)FlameGraphView.this.fEventMenuManager);
                FlameGraphView.this.fEventMenuManager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        this.getSite().registerContextMenu(this.fEventMenuManager, this.fTimeGraphViewer.getSelectionProvider());
    }

    protected void fillTimeEventContextMenu(@NonNull IMenuManager menuManager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object object : ((IStructuredSelection)selection).toList()) {
                if (!(object instanceof FlamegraphEvent)) continue;
                final FlamegraphEvent flamegraphEvent = (FlamegraphEvent)((Object)object);
                menuManager.add((IAction)new Action(Messages.FlameGraphView_GotoMaxDuration){

                    public void run() {
                        ISegment maxSeg = flamegraphEvent.getStatistics().getMaxSegment();
                        TmfSelectionRangeUpdatedSignal sig = new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.fromNanos((long)maxSeg.getStart()), TmfTimestamp.fromNanos((long)maxSeg.getEnd()));
                        FlameGraphView.this.broadcast((TmfSignal)sig);
                    }
                });
                menuManager.add((IAction)new Action(Messages.FlameGraphView_GotoMinDuration){

                    public void run() {
                        ISegment minSeg = flamegraphEvent.getStatistics().getMinSegment();
                        TmfSelectionRangeUpdatedSignal sig = new TmfSelectionRangeUpdatedSignal((Object)this, TmfTimestamp.fromNanos((long)minSeg.getStart()), TmfTimestamp.fromNanos((long)minSeg.getEnd()));
                        FlameGraphView.this.broadcast((TmfSignal)sig);
                    }
                });
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.getSortByNameAction());
        manager.add((IAction)this.getSortByIdAction());
        manager.add((IContributionItem)new Separator());
    }

    private Action getSortByNameAction() {
        if (this.fSortByNameAction == null) {
            this.fSortByNameAction = new Action(Messages.FlameGraph_SortByThreadName, 2){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fTimeGraphContentProvider.getSortOption();
                    if (sortOption == SortOption.BY_NAME) {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME);
                    }
                }
            };
            this.fSortByNameAction.setToolTipText(Messages.FlameGraph_SortByThreadName);
            this.fSortByNameAction.setImageDescriptor(SORT_BY_NAME_ICON);
        }
        return this.fSortByNameAction;
    }

    private Action getSortByIdAction() {
        if (this.fSortByIdAction == null) {
            this.fSortByIdAction = new Action(Messages.FlameGraph_SortByThreadId, 2){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fTimeGraphContentProvider.getSortOption();
                    if (sortOption == SortOption.BY_ID) {
                        FlameGraphView.this.setSortOption(SortOption.BY_ID_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_ID);
                    }
                }
            };
            this.fSortByIdAction.setToolTipText(Messages.FlameGraph_SortByThreadId);
            this.fSortByIdAction.setImageDescriptor(SORT_BY_ID_ICON);
        }
        return this.fSortByIdAction;
    }

    private void setSortOption(SortOption sortOption) {
        this.getSortByNameAction().setChecked(false);
        this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_ICON);
        this.getSortByIdAction().setChecked(false);
        this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_ICON);
        if (sortOption.equals((Object)SortOption.BY_NAME)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_NAME);
            this.getSortByNameAction().setChecked(true);
        } else if (sortOption.equals((Object)SortOption.BY_NAME_REV)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_NAME_REV);
            this.getSortByNameAction().setChecked(true);
            this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_REV_ICON);
        } else if (sortOption.equals((Object)SortOption.BY_ID)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_ID);
            this.getSortByIdAction().setChecked(true);
        } else if (sortOption.equals((Object)SortOption.BY_ID_REV)) {
            this.fTimeGraphContentProvider.setSortOption(SortOption.BY_ID_REV);
            this.getSortByIdAction().setChecked(true);
            this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_REV_ICON);
        }
        this.saveSortOption();
        this.fTimeGraphViewer.refresh();
    }

    private void saveSortOption() {
        SortOption sortOption = this.fTimeGraphContentProvider.getSortOption();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        section.put(SORT_OPTION_KEY, sortOption.name());
    }

    private void loadSortOption() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            return;
        }
        String sortOption = section.get(SORT_OPTION_KEY);
        if (sortOption == null) {
            return;
        }
        this.setSortOption(SortOption.fromName(sortOption));
    }
}

