/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.callgraph;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.Messages;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.SymbolProviderManager;

public final class SymbolAspect
implements ISegmentAspect {
    public static final @NonNull ISegmentAspect SYMBOL_ASPECT = new SymbolAspect();

    public @NonNull String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.CallStack_FunctionName);
    }

    public @NonNull String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.CallStack_FunctionName);
    }

    public @Nullable Comparator<?> getComparator() {
        return new Comparator<ISegment>(){

            @Override
            public int compare(@Nullable ISegment o1, @Nullable ISegment o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException();
                }
                return Long.compare(o1.getLength(), o2.getLength());
            }
        };
    }

    public @Nullable Object resolve(@NonNull ISegment segment) {
        if (segment instanceof ICalledFunction) {
            ICalledFunction calledFunction = (ICalledFunction)segment;
            ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
            if (trace != null) {
                Object symbol = calledFunction.getSymbol();
                if (symbol instanceof Long) {
                    String text;
                    Long longAddress = (Long)symbol;
                    ISymbolProvider provider = SymbolProviderManager.getInstance().getSymbolProvider(trace);
                    String symbolText = provider.getSymbolText(longAddress.longValue());
                    if (symbolText == null) {
                        return "0x" + Long.toHexString(longAddress);
                    }
                    long time = segment.getStart();
                    int pid = calledFunction.getProcessId();
                    if (pid > 0 && (text = provider.getSymbolText(pid, time, longAddress.longValue())) != null) {
                        return text;
                    }
                    return symbolText;
                }
                return String.valueOf(symbol);
            }
        }
        return null;
    }
}

