/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;

public final class AlignmentParser
implements ICommonTreeParser {
    public static final AlignmentParser INSTANCE = new AlignmentParser();
    private static final String INVALID_VALUE_FOR_ALIGNMENT = "Invalid value for alignment";

    private AlignmentParser() {
    }

    @Override
    public Long parse(CommonTree tree, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (tree.getType() == 86) {
            if (tree.getChildCount() > 1) {
                throw new ParseException(INVALID_VALUE_FOR_ALIGNMENT);
            }
            return this.parse((CommonTree)tree.getChild(0), param);
        }
        if (TsdlUtils.isUnaryInteger(tree)) {
            long alignment = UnaryIntegerParser.INSTANCE.parse(tree, null);
            if (!AlignmentParser.isValidAlignment(alignment)) {
                throw new ParseException("Invalid value for alignment : " + alignment);
            }
            return alignment;
        }
        throw new ParseException(INVALID_VALUE_FOR_ALIGNMENT);
    }

    private static boolean isValidAlignment(long alignment) {
        return alignment > 0L && (alignment & alignment - 1L) == 0L;
    }
}

