/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ExpressionManager;

public class WatchExpression
implements IWatchExpression {
    protected String fExpressionText;
    protected IWatchExpressionResult fResult;
    protected IDebugElement fCurrentContext;
    private boolean fEnabled = true;
    private boolean fPending = false;

    public WatchExpression(String expression) {
        this.fExpressionText = expression;
    }

    public WatchExpression(String expressionText, boolean enabled) {
        this(expressionText);
        this.fEnabled = enabled;
    }

    @Override
    public void evaluate() {
        IDebugElement context = this.fCurrentContext;
        if (context == null) {
            return;
        }
        IWatchExpressionListener listener = new IWatchExpressionListener(){

            @Override
            public void watchEvaluationFinished(IWatchExpressionResult result) {
                WatchExpression.this.setResult(result);
            }
        };
        this.setPending(true);
        IWatchExpressionDelegate delegate = DebugPlugin.getDefault().getExpressionManager().newWatchExpressionDelegate(context.getModelIdentifier());
        if (delegate != null) {
            delegate.evaluateExpression(this.getExpressionText(), context, listener);
        } else {
            listener.watchEvaluationFinished(new IWatchExpressionResult(){

                @Override
                public IValue getValue() {
                    return null;
                }

                @Override
                public boolean hasErrors() {
                    return true;
                }

                @Override
                public String[] getErrorMessages() {
                    return new String[]{DebugCoreMessages.WatchExpression_0};
                }

                @Override
                public String getExpressionText() {
                    return WatchExpression.this.getExpressionText();
                }

                @Override
                public DebugException getException() {
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpressionContext(IDebugElement context) {
        WatchExpression watchExpression = this;
        synchronized (watchExpression) {
            this.fCurrentContext = context;
        }
        if (context == null) {
            this.setResult(null);
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.evaluate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(IWatchExpressionResult result) {
        WatchExpression watchExpression = this;
        synchronized (watchExpression) {
            this.fResult = result;
            this.fPending = false;
        }
        this.fireEvent(new DebugEvent(this, 16, 256));
        this.fireEvent(new DebugEvent(this, 16, 512));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    private void watchExpressionChanged() {
        ((ExpressionManager)DebugPlugin.getDefault().getExpressionManager()).watchExpressionChanged(this);
    }

    @Override
    public String getExpressionText() {
        return this.fExpressionText;
    }

    @Override
    public synchronized IValue getValue() {
        if (this.fResult == null) {
            return null;
        }
        return this.fResult.getValue();
    }

    @Override
    public IDebugTarget getDebugTarget() {
        IDebugElement element = this.fCurrentContext;
        if (element != null) {
            return element.getDebugTarget();
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getModelIdentifier() {
        WatchExpression watchExpression = this;
        synchronized (watchExpression) {
            IValue value = this.getValue();
            if (value != null) {
                return value.getModelIdentifier();
            }
            if (this.fCurrentContext != null) {
                return this.fCurrentContext.getModelIdentifier();
            }
        }
        return DebugPlugin.getUniqueIdentifier();
    }

    @Override
    public ILaunch getLaunch() {
        IDebugTarget debugTarget = this.getDebugTarget();
        if (debugTarget != null) {
            return debugTarget.getLaunch();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        ILaunch launch;
        if (adapter.equals(ILaunchConfiguration.class) && (launch = this.getLaunch()) != null) {
            return (T)launch.getLaunchConfiguration();
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.watchExpressionChanged();
        this.evaluate();
    }

    @Override
    public void setExpressionText(String expression) {
        this.fExpressionText = expression;
        this.watchExpressionChanged();
        this.evaluate();
    }

    @Override
    public boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public synchronized boolean isPending() {
        return this.fPending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPending(boolean pending) {
        WatchExpression watchExpression = this;
        synchronized (watchExpression) {
            this.fPending = pending;
        }
        this.fireEvent(new DebugEvent(this, 16, 256));
    }

    @Override
    public boolean hasErrors() {
        return this.fResult != null && this.fResult.hasErrors();
    }

    @Override
    public String[] getErrorMessages() {
        if (this.fResult == null) {
            return new String[0];
        }
        return this.fResult.getErrorMessages();
    }
}

