/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import com.google.common.collect.ImmutableList;
import java.util.List;

public class LamiChartModel {
    private final ChartType fType;
    private final String fName;
    private final List<String> fXSeriesColumns;
    private final List<String> fYSeriesColumns;
    private final boolean fXAxisIsLog;
    private final boolean fYAxisIsLog;

    public LamiChartModel(ChartType type, String name, List<String> xSeriesColumn, List<String> ySeriesColumns, boolean xAxisIsLog, boolean yAxisIsLog) {
        this.fType = type;
        this.fName = name;
        this.fXSeriesColumns = ImmutableList.copyOf(xSeriesColumn);
        this.fYSeriesColumns = ImmutableList.copyOf(ySeriesColumns);
        this.fXAxisIsLog = xAxisIsLog;
        this.fYAxisIsLog = yAxisIsLog;
    }

    public ChartType getChartType() {
        return this.fType;
    }

    public String getName() {
        return this.fName;
    }

    public List<String> getXSeriesColumns() {
        return this.fXSeriesColumns;
    }

    public List<String> getYSeriesColumns() {
        return this.fYSeriesColumns;
    }

    public boolean xAxisIsLog() {
        return this.fXAxisIsLog;
    }

    public boolean yAxisIsLog() {
        return this.fYAxisIsLog;
    }

    public static enum ChartType {
        BAR_CHART("Bar"),
        XY_SCATTER("Scatter"),
        PIE_CHART("Pie");

        private final String fText;

        private ChartType(String text) {
            this.fText = text;
        }

        public String toString() {
            return this.fText;
        }
    }
}

