/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.dialogs.SystemControlEnableState;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.ISystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.messages.SystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemPromptDialog
extends Dialog
implements Listener,
ISystemPromptDialog,
ISystemMessageLine,
IDialogPage,
IRunnableContext,
Runnable {
    protected boolean okPressed = false;
    protected boolean cancelAllPressed = false;
    protected boolean showBrowseButton = false;
    protected boolean showTestButton = false;
    protected boolean showAddButton = false;
    protected boolean showDetailsButton = false;
    protected boolean pack = false;
    protected boolean initialOKButtonEnabledState = true;
    protected boolean initialAddButtonEnabledState = false;
    protected boolean initialDetailsButtonEnabledState = true;
    protected boolean detailsButtonHideMode = false;
    protected boolean showOkButton = true;
    protected boolean showCancelAllButton = false;
    protected Shell overallShell = null;
    protected Composite parentComposite;
    protected Composite dialogAreaComposite;
    protected Composite buttonsComposite;
    protected Button okButton;
    protected Button cancelButton;
    protected Button cancelAllButton;
    protected Button testButton;
    protected Button browseButton;
    protected Button addButton;
    protected Button detailsButton;
    protected String title;
    protected String labelOk;
    protected String labelBrowse;
    protected String labelTest;
    protected String labelCancel;
    protected String labelCancelAll;
    protected String labelAdd;
    protected String labelDetailsShow;
    protected String labelDetailsHide;
    protected String tipOk;
    protected String tipBrowse;
    protected String tipTest;
    protected String tipCancel;
    protected String tipCancelAll;
    protected String tipAdd;
    protected String tipDetailsShow;
    protected String tipDetailsHide;
    protected boolean noShowAgainOption;
    protected Button noShowAgainButton;
    protected String detailsShowLabel;
    protected String detailsHideLabel;
    protected String helpId;
    protected Image titleImage;
    protected Object inputObject;
    protected Object outputObject;
    protected SystemMessageLine fMessageLine;
    protected SystemMessage pendingMessage;
    protected SystemMessage pendingErrorMessage;
    protected int minWidth;
    protected int minHeight;
    protected int marginWidth = 3;
    protected int marginHeight = 3;
    protected int verticalSpacing = 2;
    protected int horizontalSpacing = 3;
    protected Mnemonics dialogMnemonics;
    protected ISystemValidator outputObjectValidator;
    protected long activeRunningOperations = 0L;
    protected boolean operationCancelableState;
    protected boolean needsProgressMonitor;
    protected ProgressMonitorPart progressMonitorPart;
    protected Cursor waitCursor;
    protected Cursor arrowCursor;
    protected MessageDialog windowClosingDialog;
    protected SelectionAdapter cancelListener;
    protected IPreferenceStore prefStore;
    protected String prefId;
    protected boolean prefValAsSelected;
    private static final String FOCUS_CONTROL = "focusControl";
    protected static final int BROWSE_ID = 50;
    protected static final int TEST_ID = 60;
    protected static final int ADD_ID = 70;
    protected static final int DETAILS_ID = 80;
    protected static final int CANCEL_ALL_ID = 90;
    protected static final boolean BROWSE_BUTTON_YES = true;
    protected static final boolean BROWSE_BUTTON_NO = false;
    protected static final boolean TEST_BUTTON_YES = true;
    protected static final boolean TEST_BUTTON_NO = false;
    protected static final boolean ADD_BUTTON_YES = true;
    protected static final boolean ADD_BUTTON_NO = false;
    protected static final boolean DETAILS_BUTTON_YES = true;
    protected static final boolean DETAILS_BUTTON_NO = false;

    public SystemPromptDialog(Shell shell, String title) {
        this(shell, title, null, false);
    }

    public SystemPromptDialog(Shell shell, String title, Image titleImage) {
        this(shell, title, null, false, titleImage);
    }

    public SystemPromptDialog(Shell shell, String title, Object inputObject) {
        this(shell, title, inputObject, false);
    }

    public SystemPromptDialog(Shell shell, String title, boolean browse) {
        this(shell, title, null, browse);
    }

    public SystemPromptDialog(Shell shell, String title, Object inputObject, boolean browse) {
        this(shell, title, inputObject, browse, null);
    }

    public SystemPromptDialog(Shell shell, String title, Object inputObject, boolean browse, Image titleImage) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.title = title;
        this.titleImage = titleImage;
        this.inputObject = inputObject;
        this.showBrowseButton = browse;
        super.setBlockOnOpen(true);
    }

    public SystemPromptDialog(Shell shell, String title, Object inputObject, boolean browse, boolean test, Image titleImage) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.title = title;
        this.titleImage = titleImage;
        this.inputObject = inputObject;
        this.showBrowseButton = browse;
        this.showTestButton = test;
        super.setBlockOnOpen(true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.overallShell = shell;
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void setNeedsProgressMonitor(boolean needs) {
        this.needsProgressMonitor = needs;
    }

    public void setHelp(String helpId) {
        if (this.parentComposite != null) {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, helpId);
            SystemWidgetHelpers.setHelp((Control)this.buttonsComposite, helpId);
        }
        this.helpId = helpId;
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public void setHelp(Control c, String helpId) {
        SystemWidgetHelpers.setHelp(c, helpId);
    }

    public void setInputObject(Object inputObject) {
        this.inputObject = inputObject;
    }

    public Object getInputObject() {
        return this.inputObject;
    }

    public Object getOutputObject() {
        return this.outputObject;
    }

    public boolean wasCancelled() {
        return !this.okPressed;
    }

    public boolean wasCancelledAll() {
        return this.cancelAllPressed;
    }

    public void setOutputObjectValidator(ISystemValidator outputObjectValidator) {
        this.outputObjectValidator = outputObjectValidator;
    }

    public ICellEditorValidator getOutputObjectValidator() {
        return this.outputObjectValidator;
    }

    public ISystemMessageLine getMessageLine() {
        return this.fMessageLine;
    }

    public void setOutputObject(Object outputObject) {
        this.outputObject = outputObject;
    }

    public void setBusyCursor(boolean setBusy) {
        if (setBusy) {
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
        } else {
            this.setDisplayCursor(null);
            if (this.waitCursor != null) {
                this.waitCursor.dispose();
            }
            this.waitCursor = null;
        }
    }

    public void setShowOkButton(boolean showOk) {
        this.showOkButton = showOk;
    }

    public void setOkButtonLabel(String label) {
        this.labelOk = label;
    }

    public void setOkButtonToolTipText(String tip) {
        this.tipOk = tip;
    }

    public void enableOkButton(boolean enable) {
        if (this.okButton != null) {
            this.okButton.setEnabled(enable);
        }
    }

    public Button getOkButton() {
        return this.okButton;
    }

    public void setInitialOKButtonEnabledState(boolean enabled) {
        this.initialOKButtonEnabledState = enabled;
    }

    protected boolean processOK() {
        return true;
    }

    public void setCancelButtonLabel(String label) {
        this.labelCancel = label;
    }

    public void setCancelButtonToolTipText(String tip) {
        this.tipCancel = tip;
    }

    public void enableCancelButton(boolean enable) {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(enable);
        }
    }

    public Button getCancelOrCloseButton() {
        return this.cancelButton;
    }

    protected boolean processCancel() {
        return true;
    }

    public void setShowCancelAllButton(boolean showCancelAll) {
        this.showCancelAllButton = showCancelAll;
    }

    public void setCancelAllButtonLabel(String label) {
        this.labelCancelAll = label;
    }

    public void setCancelAllButtonToolTipText(String tip) {
        this.tipCancelAll = tip;
    }

    public void enableCancelAllButton(boolean enable) {
        if (this.cancelAllButton != null) {
            this.cancelAllButton.setEnabled(enable);
        }
    }

    public Button getCancelAllButton() {
        return this.cancelAllButton;
    }

    protected boolean processCancelAll() {
        return true;
    }

    public void setShowBrowseButton(boolean show) {
        this.showBrowseButton = show;
    }

    public void setBrowseButtonLabel(String label) {
        this.labelBrowse = label;
    }

    public void setBrowseButtonToolTipText(String tip) {
        this.tipBrowse = tip;
    }

    public void enableBrowseButton(boolean enable) {
        if (this.browseButton != null) {
            this.browseButton.setEnabled(enable);
        }
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    protected boolean processBrowse() {
        return false;
    }

    public void setShowTestButton(boolean show) {
        this.showTestButton = show;
    }

    public void setTestButtonLabel(String label) {
        this.labelTest = label;
    }

    public void setTestButtonToolTipText(String tip) {
        this.tipTest = tip;
    }

    public void enableTestButton(boolean enable) {
        if (this.testButton != null) {
            this.testButton.setEnabled(enable);
        }
    }

    public Button getTestButton() {
        return this.testButton;
    }

    protected boolean processTest() {
        return false;
    }

    public void setShowAddButton(boolean show) {
        this.showAddButton = show;
    }

    public void setAddButtonLabel(String label) {
        this.labelAdd = label;
    }

    public void setAddButtonToolTipText(String tip) {
        this.tipAdd = tip;
    }

    public void enableAddButton(boolean enable) {
        if (this.addButton != null) {
            this.addButton.setEnabled(enable);
        } else {
            this.initialAddButtonEnabledState = enable;
        }
    }

    public Button getAddButton() {
        return this.addButton;
    }

    protected boolean processAdd() {
        return false;
    }

    public void setShowDetailsButton(boolean show, boolean hideMode) {
        this.showDetailsButton = show;
        this.detailsButtonHideMode = hideMode;
    }

    public void setDetailsButtonLabel(String showLabel, String hideLabel) {
        this.labelDetailsShow = showLabel;
        this.labelDetailsHide = hideLabel;
    }

    public void setDetailsButtonToolTipText(String showTip, String hideTip) {
        this.tipDetailsShow = showTip;
        this.tipDetailsHide = hideTip;
    }

    public void enableDetailsButton(boolean enable) {
        if (this.detailsButton != null) {
            this.detailsButton.setEnabled(enable);
        } else {
            this.initialDetailsButtonEnabledState = enable;
        }
    }

    public Button getDetailsButton() {
        return this.detailsButton;
    }

    protected boolean processDetails(boolean hideMode) {
        return true;
    }

    public Mnemonics getDialogMnemonics() {
        return this.dialogMnemonics;
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        this.fMessageLine = new SystemMessageLine(c);
        this.fMessageLine.setLayoutData(new GridData(4, 0x1000000, true, false));
        Display.getCurrent().asyncExec((Runnable)this);
        return this.fMessageLine;
    }

    public void run() {
        if (this.pendingErrorMessage != null) {
            this.setErrorMessage(this.pendingErrorMessage);
        } else if (this.pendingMessage != null) {
            this.setMessage(this.pendingMessage);
        }
        this.pendingMessage = null;
        this.pendingErrorMessage = null;
    }

    public void handleEvent(Event e) {
        if (e.type == 13 && e.widget == this.noShowAgainButton) {
            boolean isNoShowSelected = this.noShowAgainButton.getSelection();
            if (this.prefStore != null && this.prefId != null) {
                if (this.prefValAsSelected) {
                    this.prefStore.setValue(this.prefId, isNoShowSelected);
                } else {
                    this.prefStore.setValue(this.prefId, !isNoShowSelected);
                }
            }
        }
    }

    protected abstract Control createInner(Composite var1);

    protected abstract Control getInitialFocusControl();

    protected void buttonPressed(int buttonId) {
        this.okPressed = false;
        if (buttonId == 0) {
            this.setReturnCode(0);
            if (this.processOK()) {
                this.okPressed = true;
                this.close();
            }
        } else if (buttonId == 50) {
            this.processBrowse();
        } else if (buttonId == 60) {
            this.processTest();
        } else if (buttonId == 70) {
            this.processAdd();
        } else if (buttonId == 80) {
            if (this.processDetails(this.detailsButtonHideMode)) {
                this.detailsButtonHideMode = !this.detailsButtonHideMode;
                this.detailsButton.setText(this.detailsButtonHideMode ? this.detailsShowLabel : this.detailsHideLabel);
                if (this.detailsButtonHideMode && this.tipDetailsShow != null) {
                    this.detailsButton.setToolTipText(this.tipDetailsShow);
                } else if (!this.detailsButtonHideMode && this.tipDetailsHide != null) {
                    this.detailsButton.setToolTipText(this.tipDetailsHide);
                }
            }
        } else if (buttonId == 90 && this.processCancelAll()) {
            this.cancelAllPressed = true;
            this.close();
        }
    }

    protected Control createButtonBar(Composite parent) {
        this.createMessageLine(parent);
        return super.createButtonBar(parent);
    }

    protected void adjustButtonWidth(Button button) {
        Object layoutData;
        String text = button.getText();
        if (text != null && text.indexOf(38) < 0 && (layoutData = button.getLayoutData()) instanceof GridData) {
            GridData gd = (GridData)layoutData;
            if (gd.widthHint != -1) {
                gd.widthHint += this.convertWidthInCharsToPixels(3);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).verticalSpacing = this.verticalSpacing;
        ((GridLayout)parent.getLayout()).marginWidth = this.marginWidth;
        ((GridLayout)parent.getLayout()).marginHeight = this.marginHeight;
        if (this.showOkButton) {
            String okLabel = this.labelOk != null ? this.labelOk : IDialogConstants.OK_LABEL;
            this.okButton = this.createButton(parent, 0, okLabel, true);
            this.okButton.setEnabled(this.initialOKButtonEnabledState);
            if (this.tipOk != null) {
                this.okButton.setToolTipText(this.tipOk);
            }
        }
        if (this.showBrowseButton) {
            String browseLabel = this.labelBrowse != null ? this.labelBrowse : SystemResources.BUTTON_BROWSE;
            this.browseButton = this.createButton(parent, 50, browseLabel, false);
            if (this.tipBrowse != null) {
                this.browseButton.setToolTipText(this.tipBrowse);
            }
        }
        if (this.showTestButton) {
            String testLabel = this.labelTest != null ? this.labelTest : SystemResources.BUTTON_TEST;
            this.testButton = this.createButton(parent, 60, testLabel, false);
            if (this.tipTest != null) {
                this.testButton.setToolTipText(this.tipTest);
            }
        }
        if (this.showAddButton) {
            String addLabel = this.labelAdd != null ? this.labelAdd : SystemResources.BUTTON_ADD;
            this.addButton = this.createButton(parent, 70, addLabel, !this.showOkButton);
            if (this.tipAdd != null) {
                this.addButton.setToolTipText(this.tipAdd);
            }
            this.addButton.setEnabled(this.initialAddButtonEnabledState);
        }
        if (this.showDetailsButton) {
            this.detailsShowLabel = Mnemonics.removeMnemonic(this.labelDetailsShow != null ? this.labelDetailsShow : IDialogConstants.SHOW_DETAILS_LABEL);
            this.detailsHideLabel = Mnemonics.removeMnemonic(this.labelDetailsHide != null ? this.labelDetailsHide : IDialogConstants.HIDE_DETAILS_LABEL);
            String detailsLabel = this.detailsButtonHideMode ? this.detailsShowLabel : this.detailsHideLabel;
            this.detailsButton = this.createButton(parent, 80, detailsLabel, false);
            this.adjustButtonWidth(this.detailsButton);
            if (this.detailsButtonHideMode && this.tipDetailsShow != null) {
                this.detailsButton.setToolTipText(this.tipDetailsShow);
            } else if (!this.detailsButtonHideMode && this.tipDetailsHide != null) {
                this.detailsButton.setToolTipText(this.tipDetailsHide);
            }
            this.detailsButton.setEnabled(this.initialDetailsButtonEnabledState);
        }
        String cancelLabel = this.labelCancel != null ? this.labelCancel : IDialogConstants.CANCEL_LABEL;
        this.cancelButton = this.createButton(parent, 1, cancelLabel, false);
        if (this.tipCancel != null) {
            this.cancelButton.setToolTipText(this.tipCancel);
        }
        this.cancelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SystemPromptDialog.this.activeRunningOperations <= 0L) {
                    if (SystemPromptDialog.this.processCancel()) {
                        SystemPromptDialog.this.doCancel();
                    }
                } else {
                    SystemPromptDialog.this.cancelButton.setEnabled(false);
                }
            }
        };
        this.cancelButton.addSelectionListener((SelectionListener)this.cancelListener);
        if (this.showCancelAllButton) {
            String cancelAllLabel = this.labelCancelAll != null ? this.labelCancelAll : SystemResources.BUTTON_CANCEL_ALL;
            this.cancelAllButton = this.createButton(parent, 90, cancelAllLabel, false);
            if (this.tipCancelAll != null) {
                this.cancelAllButton.setToolTipText(this.tipCancelAll);
            }
        }
        this.buttonsComposite = parent;
        if (this.helpId != null) {
            SystemWidgetHelpers.setHelp((Control)this.buttonsComposite, this.helpId);
        }
    }

    private void doCancel() {
        super.buttonPressed(1);
    }

    public void setMinimumSize(int width, int height) {
        this.minWidth = width;
        this.minHeight = height;
    }

    protected Control createContents(Composite parent) {
        Control initialFocusControl;
        Control c = super.createContents(parent);
        this.parentComposite = (Composite)c;
        if (this.helpId != null) {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, this.helpId);
        }
        if (this.needsProgressMonitor) {
            boolean showSeparators = false;
            Label separator = null;
            if (showSeparators) {
                separator = new Label(this.parentComposite, 258);
                separator.setLayoutData((Object)new GridData(768));
            }
            GridLayout pmlayout = new GridLayout();
            pmlayout.numColumns = 1;
            this.progressMonitorPart = new ProgressMonitorPart(this.parentComposite, (Layout)pmlayout, -1);
            this.progressMonitorPart.setLayoutData((Object)new GridData(768));
            this.progressMonitorPart.setVisible(false);
            if (showSeparators) {
                separator = new Label(this.parentComposite, 258);
                separator.setLayoutData((Object)new GridData(768));
            }
            if (RSECorePlugin.isTheSystemRegistryActive()) {
                RSEUIPlugin.getTheSystemRegistryUI().setRunnableContext(this.getShell(), this);
                this.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        RSEUIPlugin.getTheSystemRegistryUI().clearRunnableContext();
                    }
                });
            }
        }
        if ((initialFocusControl = this.getInitialFocusControl()) != null) {
            initialFocusControl.setFocus();
        }
        this.dialogMnemonics = SystemWidgetHelpers.setMnemonics((Composite)this.getButtonBar());
        this.applyMnemonics(this.dialogMnemonics, (Composite)this.getDialogArea());
        if (this.showDetailsButton) {
            if (this.detailsButtonHideMode) {
                this.detailsShowLabel = this.detailsButton.getText();
                char m = Mnemonics.getMnemonic(this.detailsShowLabel);
                this.detailsHideLabel = Mnemonics.applyMnemonic(this.detailsHideLabel, m);
            } else {
                this.detailsHideLabel = this.detailsButton.getText();
                char m = Mnemonics.getMnemonic(this.detailsHideLabel);
                this.detailsShowLabel = Mnemonics.applyMnemonic(this.detailsShowLabel, m);
            }
        }
        if (this.labelCancel != null) {
            this.labelCancel = this.cancelButton.getText();
        }
        if (this.pack) {
            Shell shell = this.getShell();
            shell.setSize(shell.computeSize(-1, -1, true));
        }
        return c;
    }

    protected void applyMnemonics(Mnemonics mnemonics, Composite c) {
        SystemWidgetHelpers.setMnemonics(mnemonics, c);
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        boolean newData;
        Composite c;
        this.dialogAreaComposite = c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = this.marginWidth;
        layout.marginWidth = this.marginHeight;
        layout.verticalSpacing = this.verticalSpacing;
        layout.horizontalSpacing = this.horizontalSpacing;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)new GridData(1808));
        Control inner = this.createInner(c);
        if (this.noShowAgainOption) {
            this.noShowAgainButton = this.createNoShowAgainButton(c);
        }
        if (this.minWidth > 0) {
            newData = false;
            data = (GridData)inner.getLayoutData();
            if (data == null) {
                newData = true;
                data = new GridData();
            }
            data.widthHint = this.minWidth;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            if (newData) {
                inner.setLayoutData((Object)data);
            }
        }
        if (this.minHeight > 0) {
            newData = false;
            data = (GridData)inner.getLayoutData();
            if (data == null) {
                newData = true;
                data = new GridData();
            }
            data.heightHint = this.minHeight;
            data.grabExcessVerticalSpace = true;
            data.verticalAlignment = 4;
            if (newData) {
                inner.setLayoutData((Object)data);
            }
        }
        return c;
    }

    public void setNoShowAgainOption(boolean noShowAgainOption, IPreferenceStore prefStore, String prefId, boolean prefValAsSelected) {
        this.noShowAgainOption = noShowAgainOption;
        this.prefStore = prefStore;
        this.prefId = prefId;
        this.prefValAsSelected = prefValAsSelected;
    }

    protected Button createNoShowAgainButton(Composite c) {
        Button b = new Button(c, 32);
        b.setText(SystemResources.RESID_DO_NOT_SHOW_MESSAGE_AGAIN_LABEL);
        b.setToolTipText(SystemResources.RESID_DO_NOT_SHOW_MESSAGE_AGAIN_TOOLTIP);
        b.addListener(13, (Listener)this);
        return b;
    }

    public void setPageComplete(boolean complete) {
        if (this.okButton != null) {
            this.okButton.setEnabled(complete);
        } else {
            this.initialOKButtonEnabledState = complete;
        }
    }

    protected Label addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Label addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
        return filler;
    }

    protected Label addGrowableFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        filler.setLayoutData((Object)data);
        return filler;
    }

    public int publicConvertWidthInCharsToPixels(int chars) {
        return this.convertWidthInCharsToPixels(chars);
    }

    public int publicConvertHeightInCharsToPixels(int chars) {
        return this.convertHeightInCharsToPixels(chars);
    }

    public void clearErrorMessage() {
        if (this.fMessageLine != null) {
            this.fMessageLine.clearErrorMessage();
        }
    }

    public void clearMessage() {
        if (this.fMessageLine != null) {
            this.fMessageLine.clearMessage();
        }
    }

    public String getErrorMessage() {
        if (this.fMessageLine != null) {
            return this.fMessageLine.getErrorMessage();
        }
        return null;
    }

    public SystemMessage getSystemErrorMessage() {
        if (this.fMessageLine != null) {
            return this.fMessageLine.getSystemErrorMessage();
        }
        return null;
    }

    public String getMessage() {
        if (this.fMessageLine != null) {
            return this.fMessageLine.getMessage();
        }
        return null;
    }

    public void setErrorMessage(String message) {
        if (this.fMessageLine != null) {
            this.fMessageLine.setErrorMessage(message);
        } else {
            SystemMessageDialog.displayErrorMessage(this.getShell(), message);
        }
    }

    public void setErrorMessage(SystemMessage message) {
        if (this.fMessageLine != null) {
            if (message != null) {
                this.fMessageLine.setErrorMessage(message);
            } else {
                this.fMessageLine.clearErrorMessage();
            }
        } else {
            this.pendingErrorMessage = message;
        }
    }

    public void setMessage(String message) {
        if (this.fMessageLine != null) {
            if (message != null) {
                this.fMessageLine.setMessage(message);
            } else {
                this.fMessageLine.clearMessage();
            }
        }
    }

    public void setMessage(SystemMessage message) {
        if (this.fMessageLine != null) {
            this.fMessageLine.setMessage(message);
        } else if (message != null) {
            this.pendingMessage = message;
        }
    }

    public void setErrorMessage(Throwable exc) {
        if (this.fMessageLine != null) {
            this.fMessageLine.setErrorMessage(exc);
        } else {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEF8002");
            msg.makeSubstitution((Object)exc);
            new SystemMessageDialog(this.getShell(), msg).open();
        }
    }

    public void setDescription(String description) {
    }

    public String getDescription() {
        return null;
    }

    public Image getImage() {
        return this.titleImage;
    }

    public void performHelp() {
    }

    public void setVisible(boolean visible) {
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.parentComposite;
    }

    public void setControl(Control c) {
    }

    public void createControl(Composite parent) {
    }

    public void setImageDescriptor(ImageDescriptor id) {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.overallShell != null) {
            this.overallShell.setText(title);
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    protected Object aboutToStart(boolean enableCancelButton) {
        Map savedState = null;
        this.operationCancelableState = enableCancelButton;
        if (this.getShell() != null && this.activeRunningOperations <= 0L) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            this.cancelButton.removeSelectionListener((SelectionListener)this.cancelListener);
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
            this.arrowCursor = new Cursor((Device)d, 0);
            this.cancelButton.setCursor(this.arrowCursor);
            if (this.labelCancel != null) {
                this.cancelButton.setText("&" + IDialogConstants.CANCEL_LABEL);
            }
            savedState = this.saveUIState(this.needsProgressMonitor && enableCancelButton);
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
            if (this.needsProgressMonitor) {
                this.progressMonitorPart.attachToCancelComponent((Control)this.cancelButton);
                this.progressMonitorPart.setVisible(true);
            }
        }
        return savedState;
    }

    protected MessageDialog createWizardClosingDialog() {
        MessageDialog result = new MessageDialog(this.getShell(), JFaceResources.getString((String)"WizardClosingDialog.title"), null, JFaceResources.getString((String)"WizardClosingDialog.message"), 3, new String[]{IDialogConstants.OK_LABEL}, 0);
        return result;
    }

    public boolean close() {
        if (this.okToClose()) {
            return this.hardClose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean okToClose() {
        if (this.activeRunningOperations > 0L) {
            SystemPromptDialog systemPromptDialog = this;
            synchronized (systemPromptDialog) {
                this.windowClosingDialog = this.createWizardClosingDialog();
            }
            this.windowClosingDialog.open();
            systemPromptDialog = this;
            synchronized (systemPromptDialog) {
                this.windowClosingDialog = null;
            }
            return false;
        }
        return true;
    }

    protected boolean hardClose() {
        return super.close();
    }

    protected void restoreEnableState(Control w, Map h, String key) {
        Boolean b;
        if (w != null && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    protected void restoreUIState(Map state) {
        this.restoreEnableState((Control)this.okButton, state, "ok");
        this.restoreEnableState((Control)this.testButton, state, "test");
        this.restoreEnableState((Control)this.browseButton, state, "browse");
        this.restoreEnableState((Control)this.cancelButton, state, "cancel");
        this.restoreEnableState((Control)this.addButton, state, "add");
        this.restoreEnableState((Control)this.detailsButton, state, "details");
        SystemControlEnableState pageState = (SystemControlEnableState)state.get("page");
        pageState.restore();
    }

    protected Map saveUIState(boolean keepCancelEnabled) {
        HashMap<String, SystemControlEnableState> savedState = new HashMap<String, SystemControlEnableState>(10);
        this.saveEnableStateAndSet((Control)this.okButton, savedState, "ok", false);
        this.saveEnableStateAndSet((Control)this.testButton, savedState, "test", false);
        this.saveEnableStateAndSet((Control)this.browseButton, savedState, "browse", false);
        this.saveEnableStateAndSet((Control)this.cancelButton, savedState, "cancel", keepCancelEnabled);
        this.saveEnableStateAndSet((Control)this.addButton, savedState, "add", false);
        this.saveEnableStateAndSet((Control)this.detailsButton, savedState, "details", false);
        savedState.put("page", SystemControlEnableState.disable((Control)this.dialogAreaComposite));
        return savedState;
    }

    protected void saveEnableStateAndSet(Control w, Map h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, new Boolean(w.isEnabled()));
            w.setEnabled(enabled);
        }
    }

    protected void setDisplayCursor(Cursor c) {
        SystemPromptDialog.setDisplayCursor(this.getShell(), c);
    }

    public static void setDisplayCursor(Shell shell, Cursor c) {
        if (shell != null && shell.getDisplay() != null) {
            Shell[] shells = shell.getDisplay().getShells();
            int i = 0;
            while (i < shells.length) {
                shells[i].setCursor(c);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = this.aboutToStart(fork && cancelable);
        ++this.activeRunningOperations;
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            --this.activeRunningOperations;
            this.stopped(state);
            throw throwable;
        }
        {
            Object var5_7 = null;
            --this.activeRunningOperations;
            this.stopped(state);
            return;
        }
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null && this.activeRunningOperations <= 0L) {
            if (this.needsProgressMonitor) {
                this.progressMonitorPart.setVisible(false);
                this.progressMonitorPart.removeFromCancelComponent((Control)this.cancelButton);
            }
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.cancelButton.addSelectionListener((SelectionListener)this.cancelListener);
            this.setDisplayCursor(null);
            this.cancelButton.setCursor(null);
            if (this.labelCancel != null) {
                this.cancelButton.setText(this.labelCancel);
            }
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }
}

