/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.processors.IEditableReportProcessor;
import org.eclipse.epp.logging.aeri.core.IBundle;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IStackTraceElement;
import org.eclipse.epp.logging.aeri.core.IThrowable;
import org.eclipse.epp.logging.aeri.core.util.ModelSwitch;
import org.eclipse.epp.logging.aeri.core.util.Reports;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReportPreview {
    private static final int RIGHT_PADDING_ATTRIBUTES = 20;
    private static final int RIGHT_PADDING_EDIT = 50;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private StyledText styledText;
    private final Font headlineFont;
    private List<SectionsProvider> sectionProviders = ImmutableList.of((Object)new ReportSectionProvider(), (Object)new StatusSectionProvider(), (Object)new BundlesSectionProvider(), (Object)new AuxiliaryInformationSectionProvider());
    private Cursor handCursor = new Cursor((Device)Display.getDefault(), 21);
    private Cursor arrowCursor = new Cursor((Device)Display.getDefault(), 0);
    private Color hyperlinkColor = JFaceColors.getHyperlinkText((Display)Display.getDefault());
    private IEditListener editListener;
    private Set<IProcessorDescriptor> editedDescriptors = new HashSet<IProcessorDescriptor>();

    public ReportPreview(Composite parent) {
        this.styledText = new StyledText(parent, 2816);
        this.styledText.setEditable(false);
        this.styledText.setMargins(2, 2, 2, 2);
        this.styledText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.styledText.setForeground(parent.getDisplay().getSystemColor(16));
        this.styledText.setVisible(false);
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent event) {
                if (event.count == 1) {
                    try {
                        int offset = ReportPreview.this.styledText.getOffsetAtLocation(new Point(event.x, event.y));
                        StyleRange styleRange = ReportPreview.this.styledText.getStyleRangeAtOffset(offset);
                        if (styleRange != null && styleRange.data instanceof Runnable) {
                            ((Runnable)styleRange.data).run();
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        });
        this.styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                ReportPreview.this.styledText.setCursor(ReportPreview.this.arrowCursor);
                try {
                    int offset = ReportPreview.this.styledText.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange styleRange = ReportPreview.this.styledText.getStyleRangeAtOffset(offset);
                    if (styleRange != null && styleRange.data instanceof Runnable) {
                        ReportPreview.this.styledText.setCursor(ReportPreview.this.handCursor);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        });
        FontData[] fd = this.styledText.getFont().getFontData();
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        String name = fd[0].getName();
        if (!fontRegistry.hasValueFor(name)) {
            fontRegistry.put(name, fd);
        }
        this.headlineFont = fontRegistry.getBold(name);
    }

    public void setEditListener(IEditListener editCallback) {
        this.editListener = editCallback;
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    public void preview(IReport report, IStatus status, String serverName, List<IProcessorDescriptor> descriptors, IEclipseContext context, Shell parent) {
        StringBuilder text = new StringBuilder();
        text.append("The following will be send to: ").append(serverName).append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        for (SectionsProvider sectionsProvider : this.sectionProviders) {
            for (Section section : sectionsProvider.createSections(report, status, serverName, descriptors, context, parent)) {
                if (text.length() > 0) {
                    text.append(LINE_SEPARATOR);
                }
                if (section.getHeadlineStyleRanges().isEmpty()) {
                    section.getHeadlineStyleRanges().add(this.createHeadlineStyleRange(section.getHeadline()));
                }
                section.getHeadlineStyleRanges().forEach(x -> {
                    int n = x.start = x.start + text.length();
                });
                styleRanges.addAll(section.getHeadlineStyleRanges());
                text.append(section.getHeadline()).append(LINE_SEPARATOR).append(LINE_SEPARATOR);
                section.getTextStyleRanges().forEach(x -> {
                    int n = x.start = x.start + text.length();
                });
                styleRanges.addAll(section.getTextStyleRanges());
                text.append(section.getText().trim()).append(LINE_SEPARATOR).append(LINE_SEPARATOR);
            }
        }
        this.styledText.setText(text.toString());
        this.styledText.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }

    private StyleRange createHeadlineStyleRange(String headline) {
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = headline.length();
        range.font = this.headlineFont;
        return range;
    }

    private void appendAttributes(EObject object, StringBuilder builder) {
        for (EAttribute attribute : object.eClass().getEAllAttributes()) {
            Object value = Objects.firstNonNull((Object)object.eGet((EStructuralFeature)attribute), (Object)"");
            builder.append(StringUtils.rightPad((String)attribute.getName(), (int)20));
            builder.append(value);
            builder.append(LINE_SEPARATOR);
        }
        builder.append(LINE_SEPARATOR);
    }

    public Set<IProcessorDescriptor> getEditedDescriptors() {
        return this.editedDescriptors;
    }

    private class AuxiliaryInformationSectionProvider
    implements SectionsProvider {
        private static final String LABEL_EDIT = "Edit";
        private static final String LABEL_RESET = "Reset";

        private AuxiliaryInformationSectionProvider() {
        }

        @Override
        public List<Section> createSections(IReport report, final IStatus status, String serverName, List<IProcessorDescriptor> descriptors, final IEclipseContext context, final Shell parent) {
            ArrayList<Section> sections = new ArrayList<Section>();
            Map directiveToDescriptor = descriptors.stream().collect(Collectors.toMap(IProcessorDescriptor::getDirective, Function.identity()));
            for (Map.Entry entry : report.getAuxiliaryInformation()) {
                String directive = (String)entry.getKey();
                final IProcessorDescriptor directiveDescriptor = (IProcessorDescriptor)directiveToDescriptor.get(directive);
                String headline = directiveDescriptor != null ? StringUtils.abbreviate((String)directiveDescriptor.getName(), (int)49) : directive;
                String information = ((String)entry.getValue()).trim();
                String text = String.valueOf(information) + LINE_SEPARATOR + LINE_SEPARATOR;
                ArrayList<StyleRange> headlineStyleRanges = new ArrayList<StyleRange>();
                if (directiveDescriptor != null && directiveDescriptor.getProcessor() instanceof IEditableReportProcessor) {
                    boolean showReset = ReportPreview.this.editedDescriptors.contains(directiveDescriptor);
                    if (showReset) {
                        headline = StringUtils.rightPad((String)headline, (int)50);
                        headlineStyleRanges.add(ReportPreview.this.createHeadlineStyleRange(headline));
                        String reset = LABEL_RESET;
                        StyleRange resetStyleRange = new StyleRange();
                        resetStyleRange.start = headline.length();
                        resetStyleRange.length = reset.length();
                        resetStyleRange.underline = true;
                        resetStyleRange.foreground = ReportPreview.this.hyperlinkColor;
                        resetStyleRange.data = new Runnable(){

                            @Override
                            public void run() {
                                ((IEditableReportProcessor)((Object)directiveDescriptor.getProcessor())).reset(status, context);
                                ReportPreview.this.editedDescriptors.remove(directiveDescriptor);
                                if (ReportPreview.this.editListener != null) {
                                    ReportPreview.this.editListener.handleEdit(true);
                                }
                            }
                        };
                        headline = String.valueOf(headline) + reset;
                        headline = String.valueOf(headline) + " ";
                        headlineStyleRanges.add(resetStyleRange);
                    } else {
                        headline = StringUtils.rightPad((String)headline, (int)(50 + LABEL_RESET.length() + 1));
                        headlineStyleRanges.add(ReportPreview.this.createHeadlineStyleRange(headline));
                    }
                    String edit = LABEL_EDIT;
                    StyleRange editStyleRange = new StyleRange();
                    editStyleRange.start = headline.length();
                    editStyleRange.length = edit.length();
                    editStyleRange.underline = true;
                    editStyleRange.foreground = ReportPreview.this.hyperlinkColor;
                    editStyleRange.data = new Runnable(){

                        @Override
                        public void run() {
                            IEditableReportProcessor.EditResult editResult = ((IEditableReportProcessor)((Object)directiveDescriptor.getProcessor())).edit(status, context, parent);
                            if (editResult == IEditableReportProcessor.EditResult.MODIFIED) {
                                ReportPreview.this.editedDescriptors.add(directiveDescriptor);
                                if (ReportPreview.this.editListener != null) {
                                    ReportPreview.this.editListener.handleEdit(false);
                                }
                            }
                        }
                    };
                    headline = String.valueOf(headline) + edit;
                    headlineStyleRanges.add(editStyleRange);
                    sections.add(new Section(headline, headlineStyleRanges, text, new ArrayList<StyleRange>()));
                    continue;
                }
                headline = StringUtils.rightPad((String)headline, (int)(50 + LABEL_EDIT.length() + LABEL_RESET.length() + 1));
                headlineStyleRanges.add(ReportPreview.this.createHeadlineStyleRange(headline));
                sections.add(new Section(headline, text));
            }
            return sections;
        }
    }

    private class BundlesSectionProvider
    implements SectionsProvider {
        private BundlesSectionProvider() {
        }

        @Override
        public List<Section> createSections(IReport report, IStatus status, String serverName, List<IProcessorDescriptor> descriptors, IEclipseContext context, Shell parent) {
            String headline = "BUNDLES";
            final StringBuilder text = new StringBuilder();
            Reports.visit((EObject)report, (ModelSwitch)new ModelSwitch<Void>(){

                public Void caseBundle(IBundle bundle) {
                    ReportPreview.this.appendAttributes((EObject)bundle, text);
                    return null;
                }
            });
            if (text.toString().isEmpty()) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new Section[]{new Section(headline, text.toString())});
        }
    }

    @FunctionalInterface
    public static interface IEditListener {
        public void handleEdit(boolean var1);
    }

    private class ReportSectionProvider
    implements SectionsProvider {
        private ReportSectionProvider() {
        }

        @Override
        public List<Section> createSections(IReport report, IStatus status, String serverName, List<IProcessorDescriptor> descriptors, IEclipseContext context, Shell parent) {
            String headline = "REPORT";
            StringBuilder text = new StringBuilder();
            ReportPreview.this.appendAttributes((EObject)report, text);
            return Lists.newArrayList((Object[])new Section[]{new Section(headline, text.toString())});
        }
    }

    private static class Section {
        private String headline;
        private String text;
        private List<StyleRange> textStyleRanges;
        private List<StyleRange> headlineStyleRanges;

        Section(String headline, String text) {
            this(headline, new ArrayList<StyleRange>(), text, new ArrayList<StyleRange>());
        }

        Section(String headline, List<StyleRange> headlineStyleRanges, String text, List<StyleRange> textStyleRanges) {
            this.headline = headline;
            this.text = text;
            this.textStyleRanges = textStyleRanges;
            this.headlineStyleRanges = headlineStyleRanges;
        }

        public String getHeadline() {
            return this.headline;
        }

        public void setHeadline(String headline) {
            this.headline = headline;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public List<StyleRange> getTextStyleRanges() {
            return this.textStyleRanges;
        }

        public void setTextStyleRanges(List<StyleRange> styleRanges) {
            this.textStyleRanges = styleRanges;
        }

        public List<StyleRange> getHeadlineStyleRanges() {
            return this.headlineStyleRanges;
        }

        public void setHeadlineStyleRanges(List<StyleRange> headlineStyleRanges) {
            this.headlineStyleRanges = headlineStyleRanges;
        }
    }

    private static interface SectionsProvider {
        public List<Section> createSections(IReport var1, IStatus var2, String var3, List<IProcessorDescriptor> var4, IEclipseContext var5, Shell var6);
    }

    private class StatusSectionProvider
    implements SectionsProvider {
        private StatusSectionProvider() {
        }

        @Override
        public List<Section> createSections(IReport report, IStatus status, String serverName, List<IProcessorDescriptor> descriptors, IEclipseContext context, Shell parent) {
            final ArrayList<Section> sections = new ArrayList<Section>();
            Reports.visit((EObject)report, (ModelSwitch)new ModelSwitch<Void>(){

                public Void caseStatus(org.eclipse.epp.logging.aeri.core.IStatus status) {
                    String headline = "STATUS";
                    StringBuilder text = new StringBuilder();
                    ReportPreview.this.appendAttributes((EObject)status, text);
                    IThrowable exception = status.getException();
                    if (exception != null) {
                        text.append("Exception:");
                        this.appendStackTrace(exception, text);
                    }
                    sections.add(new Section(headline, text.toString()));
                    return null;
                }

                private void appendStackTrace(IThrowable throwable, StringBuilder builder) {
                    builder.append(String.format("%s: %s", throwable.getClassName(), throwable.getMessage())).append(LINE_SEPARATOR);
                    for (IStackTraceElement element : throwable.getStackTrace()) {
                        builder.append(String.format("\t at %s.%s(%s:%s)", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber())).append(LINE_SEPARATOR);
                    }
                    IThrowable cause = throwable.getCause();
                    if (cause != null) {
                        builder.append("Caused by: ");
                        this.appendStackTrace(cause, builder);
                    }
                }
            });
            return sections;
        }
    }
}

