/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessControlService;
import org.eclipse.remote.core.IRemoteProcessSignalService;
import org.eclipse.remote.core.IRemoteProcessTerminalService;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.JSchProcessBuilder;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JSchProcess
implements IRemoteProcessControlService,
IRemoteProcessSignalService,
IRemoteProcessTerminalService {
    private final String[] signals = new String[]{"", "HUP", "INT", "QUIT", "ILL", "", "ABRT", "", "FPE", "KILL", "", "SEGV", "", "PIPE", "ALRM", "TERM", "", "STOP", "TSTP", "CONT", "", "", "", "", "", "", "", "", "", "", "USR1", "USR2"};
    private static int WAIT_TIMEOUT = 1000;
    private static int refCount = 0;
    private final Channel fChannel;
    private final IRemoteProcess fProcess;
    private InputStream fProcStdout;
    private InputStream fProcStderr;
    private Thread fStdoutReader;
    private Thread fStderrReader;

    public JSchProcess(IRemoteProcess process) {
        this.fProcess = process;
        this.fChannel = ((JSchProcessBuilder)process.getProcessBuilder()).getChannel();
        try {
            if (process.getProcessBuilder().redirectErrorStream()) {
                PipedOutputStream pipedOutput = new PipedOutputStream();
                this.fProcStdout = new PipedInputStream(pipedOutput);
                this.fProcStderr = new NullInputStream();
                this.fStderrReader = new Thread(new ProcReader(this.fChannel.getExtInputStream(), pipedOutput));
                this.fStdoutReader = new Thread(new ProcReader(this.fChannel.getInputStream(), pipedOutput));
                this.fStderrReader.start();
                this.fStdoutReader.start();
            } else {
                this.fProcStdout = this.fChannel.getInputStream();
                this.fProcStderr = this.fChannel.getExtInputStream();
            }
        }
        catch (IOException e) {
            Activator.log(e);
            this.destroy();
        }
    }

    public void destroy() {
        this.fChannel.disconnect();
    }

    public int exitValue() {
        if (!this.isCompleted()) {
            throw new IllegalThreadStateException(Messages.JSchProcess_exitValue_exception_msg);
        }
        return this.fChannel.getExitStatus();
    }

    public InputStream getErrorStream() {
        return this.fProcStderr;
    }

    public InputStream getInputStream() {
        return this.fProcStdout;
    }

    public OutputStream getOutputStream() {
        try {
            return this.fChannel.getOutputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int waitFor() throws InterruptedException {
        while (!this.isCompleted()) {
            Thread.sleep(WAIT_TIMEOUT);
        }
        return this.exitValue();
    }

    public boolean isCompleted() {
        return this.fChannel.isClosed();
    }

    public IRemoteProcess getRemoteProcess() {
        return this.fProcess;
    }

    public void setTerminalSize(int cols, int rows, int width, int height) {
        if (this.fChannel instanceof ChannelExec) {
            ((ChannelExec)this.fChannel).setPtySize(cols, rows, width, height);
        } else if (this.fChannel instanceof ChannelShell) {
            ((ChannelShell)this.fChannel).setPtySize(cols, rows, width, height);
        }
    }

    public void sendSignal(int signal) throws RemoteConnectionException {
        if (signal >= 0 && signal <= 31) {
            try {
                this.fChannel.sendSignal(this.signals[signal]);
            }
            catch (Exception e) {
                throw new RemoteConnectionException(e.getMessage());
            }
        }
    }

    public static class Factory
    implements IRemoteProcess.Service.Factory {
        public <T extends IRemoteProcess.Service> T getService(IRemoteProcess remoteProcess, Class<T> service) {
            if (JSchProcess.class.equals(service)) {
                return (T)new JSchProcess(remoteProcess);
            }
            if (IRemoteProcessControlService.class.equals(service) || IRemoteProcessSignalService.class.equals(service) || IRemoteProcessTerminalService.class.equals(service)) {
                return (T)remoteProcess.getService(JSchProcess.class);
            }
            return null;
        }
    }

    public class NullInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }

    private class ProcReader
    implements Runnable {
        private static final int BUF_SIZE = 8192;
        private final InputStream fInput;
        private final OutputStream fOutput;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcReader(InputStream input, OutputStream output) {
            this.fInput = input;
            OutputStream outputStream = this.fOutput = output;
            synchronized (outputStream) {
                refCount = refCount + 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] b = new byte[8192];
            try {
                int len;
                while ((len = this.fInput.read(b)) > 0) {
                    this.fOutput.write(b, 0, len);
                }
            }
            catch (IOException iOException) {}
            OutputStream outputStream = this.fOutput;
            synchronized (outputStream) {
                int n = refCount - 1;
                refCount = n;
                if (n == 0) {
                    try {
                        this.fOutput.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

