/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractSegmentStatisticsAnalysis
extends TmfAbstractAnalysisModule {
    private @Nullable IAnalysisModule fSegmentStoreProviderModule;
    private @Nullable SegmentStoreStatistics fTotalStats;
    private @Nullable Map<String, SegmentStoreStatistics> fPerSegmentTypeStats;

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ISegmentStoreProvider provider;
        ITmfTrace trace = this.getTrace();
        if (trace != null && (provider = this.getSegmentProviderAnalysis(trace)) instanceof IAnalysisModule) {
            this.fSegmentStoreProviderModule = (IAnalysisModule)provider;
            return ImmutableList.of((Object)((IAnalysisModule)provider));
        }
        return super.getDependentAnalyses();
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        IAnalysisModule segmentStoreProviderModule = this.fSegmentStoreProviderModule;
        ITmfTrace trace = this.getTrace();
        if (!(segmentStoreProviderModule instanceof ISegmentStoreProvider) || trace == null) {
            return false;
        }
        segmentStoreProviderModule.waitForCompletion();
        ISegmentStore<ISegment> segStore = ((ISegmentStoreProvider)segmentStoreProviderModule).getSegmentStore();
        if (segStore != null) {
            boolean result = this.calculateTotalManual(segStore, monitor);
            if (!result) {
                return false;
            }
            result = this.calculateTotalPerType(segStore, monitor);
            if (!result) {
                return false;
            }
        }
        return true;
    }

    private boolean calculateTotalManual(ISegmentStore<ISegment> store, IProgressMonitor monitor) {
        SegmentStoreStatistics total = new SegmentStoreStatistics();
        Iterator iter = store.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return false;
            }
            ISegment segment = (ISegment)iter.next();
            total.update((ISegment)NonNullUtils.checkNotNull((Object)segment));
        }
        this.fTotalStats = total;
        return true;
    }

    private boolean calculateTotalPerType(ISegmentStore<ISegment> store, IProgressMonitor monitor) {
        HashMap<String, SegmentStoreStatistics> perSegmentTypeStats = new HashMap<String, SegmentStoreStatistics>();
        Iterator iter = store.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return false;
            }
            ISegment segment = (ISegment)iter.next();
            String segmentType = this.getSegmentType(segment);
            if (segmentType == null) continue;
            SegmentStoreStatistics values = (SegmentStoreStatistics)perSegmentTypeStats.get(segmentType);
            if (values == null) {
                values = new SegmentStoreStatistics();
            }
            values.update(segment);
            perSegmentTypeStats.put(segmentType, values);
        }
        this.fPerSegmentTypeStats = perSegmentTypeStats;
        return true;
    }

    protected abstract @Nullable String getSegmentType(ISegment var1);

    protected abstract @Nullable ISegmentStoreProvider getSegmentProviderAnalysis(ITmfTrace var1);

    protected void canceling() {
    }

    public @Nullable SegmentStoreStatistics getTotalStats() {
        return this.fTotalStats;
    }

    public @Nullable Map<String, SegmentStoreStatistics> getPerSegmentTypeStats() {
        return this.fPerSegmentTypeStats;
    }
}

