/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.wikitext.html.core.FontElementStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.HtmlSubsetLanguage;
import org.eclipse.mylyn.internal.wikitext.html.core.LiteralHtmlDocumentHandler;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanHtmlElementStrategy;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.html.core.HtmlLanguage;

public class HtmlLanguageBuilder {
    private String name;
    private final Set<DocumentBuilder.BlockType> blockTypes = Sets.newHashSet();
    private final Set<DocumentBuilder.SpanType> spanTypes = Sets.newHashSet();
    private final Map<DocumentBuilder.SpanType, String> spanTypeToElementNameSubstitution = Maps.newHashMap();
    private final List<SpanHtmlElementStrategy> spanElementStrategies = new ArrayList<SpanHtmlElementStrategy>();
    private int headingLevel;
    private LiteralHtmlDocumentHandler documentHandler;
    private boolean xhtmlStrict;

    HtmlLanguageBuilder() {
    }

    public HtmlLanguageBuilder name(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Must provide a name");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name must not be empty");
        Preconditions.checkArgument((!name.equalsIgnoreCase("HTML") ? 1 : 0) != 0, (String)"Name must not be equal to %s", (Object[])new Object[]{"HTML"});
        Preconditions.checkArgument((boolean)name.equals(name.trim()), (Object)"Name must not have leading or trailing whitespace");
        this.name = name;
        return this;
    }

    public HtmlLanguageBuilder add(DocumentBuilder.BlockType blockType) {
        this.blockTypes.add((DocumentBuilder.BlockType)Preconditions.checkNotNull((Object)blockType, (Object)"Must provide a blockType"));
        return this;
    }

    public HtmlLanguageBuilder add(DocumentBuilder.SpanType spanType) {
        this.spanTypes.add((DocumentBuilder.SpanType)Preconditions.checkNotNull((Object)spanType, (Object)"Must provide a spanType"));
        return this;
    }

    public HtmlLanguageBuilder addSubstitution(DocumentBuilder.SpanType spanType, String alternativeTagName) {
        Preconditions.checkNotNull((Object)spanType, (Object)"Must provide a spanType");
        Preconditions.checkNotNull((Object)alternativeTagName, (Object)"Must provide an alternativeTagName");
        this.spanTypeToElementNameSubstitution.put(spanType, alternativeTagName);
        return this;
    }

    public HtmlLanguageBuilder addHeadings(int level) {
        Preconditions.checkArgument((level > 0 && level <= 6 ? 1 : 0) != 0, (Object)"Heading level must be between 1 and 6");
        this.headingLevel = level;
        return this;
    }

    public HtmlLanguageBuilder addSpanFont() {
        this.spanElementStrategies.add(new FontElementStrategy());
        return this;
    }

    public HtmlLanguageBuilder setXhtmlStrict(boolean xhtmlStrict) {
        this.xhtmlStrict = xhtmlStrict;
        return this;
    }

    public HtmlLanguageBuilder document(String prefix, String suffix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Must provide a prefix");
        Preconditions.checkNotNull((Object)suffix, (Object)"Must provide a suffix");
        this.documentHandler = new LiteralHtmlDocumentHandler(prefix, suffix);
        return this;
    }

    public HtmlLanguage create() {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Name must be provided to create an HtmlLanguage");
        return new HtmlSubsetLanguage(this.name, this.documentHandler, this.headingLevel, this.blockTypes, this.spanTypes, this.spanTypeToElementNameSubstitution, this.spanElementStrategies, this.xhtmlStrict);
    }
}

