/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.nio.ByteOrder;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration.EnumParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.floatingpoint.FloatDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.IntegerDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.StringDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct.StructParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant.VariantParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderCompactDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.composite.EventHeaderLargeDeclaration;

public final class TypeSpecifierListParser
extends AbstractScopedCommonTreeParser {
    public static final TypeSpecifierListParser INSTANCE = new TypeSpecifierListParser();

    private TypeSpecifierListParser() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public IDeclaration parse(CommonTree typeSpecifierList, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        @NonNull List pointerList = ((Param)param).fListNode;
        CTFTrace trace = ((Param)param).fTrace;
        CommonTree identifier = ((Param)param).fIdentifier;
        IDeclaration declaration = null;
        CommonTree firstChild = (CommonTree)typeSpecifierList.getChild(0);
        switch (firstChild.getType()) {
            case 98: {
                declaration = FloatDeclarationParser.INSTANCE.parse(firstChild, new FloatDeclarationParser.Param(trace));
                break;
            }
            case 99: {
                declaration = IntegerDeclarationParser.INSTANCE.parse(firstChild, new IntegerDeclarationParser.Param(trace));
                break;
            }
            case 103: {
                declaration = StringDeclarationParser.INSTANCE.parse(firstChild, null);
                break;
            }
            case 104: {
                IDeclaration idEnumDecl;
                declaration = StructParser.INSTANCE.parse(firstChild, new StructParser.Param(trace, identifier, scope));
                StructDeclaration structDeclaration = (StructDeclaration)declaration;
                if (!structDeclaration.hasField("id") || !((idEnumDecl = structDeclaration.getField("id")) instanceof EnumDeclaration)) break;
                EnumDeclaration enumDeclaration = (EnumDeclaration)idEnumDecl;
                ByteOrder bo = enumDeclaration.getContainerType().getByteOrder();
                if (EventHeaderCompactDeclaration.getEventHeader(bo).isCompactEventHeader(structDeclaration)) {
                    declaration = EventHeaderCompactDeclaration.getEventHeader(bo);
                    break;
                }
                if (!EventHeaderLargeDeclaration.getEventHeader(bo).isLargeEventHeader(structDeclaration)) break;
                declaration = EventHeaderLargeDeclaration.getEventHeader(bo);
                break;
            }
            case 121: {
                declaration = VariantParser.INSTANCE.parse(firstChild, new VariantParser.Param(trace, scope));
                break;
            }
            case 89: {
                declaration = EnumParser.INSTANCE.parse(firstChild, new EnumParser.Param(trace, scope));
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 24: 
            case 31: 
            case 37: 
            case 38: 
            case 42: 
            case 45: 
            case 61: 
            case 63: 
            case 77: 
            case 79: {
                declaration = TypeDeclarationParser.INSTANCE.parse(typeSpecifierList, new TypeDeclarationParser.Param(pointerList, scope));
                break;
            }
            default: {
                throw TsdlUtils.childTypeError(firstChild);
            }
        }
        return declaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final @Nullable List<CommonTree> fListNode;
        private final CTFTrace fTrace;
        private final @Nullable CommonTree fIdentifier;

        public Param(CTFTrace trace, @Nullable List<CommonTree> listNode, @Nullable CommonTree identifier, DeclarationScope scope) {
            this.fTrace = trace;
            this.fListNode = listNode;
            this.fIdentifier = identifier;
            this.fDeclarationScope = scope;
        }
    }
}

