/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;

public final class ClockParser
implements ICommonTreeParser {
    public static final ClockParser INSTANCE = new ClockParser();

    private ClockParser() {
    }

    @Override
    public CTFClock parse(CommonTree clock, ICommonTreeParser.ICommonTreeParserParameter unused) throws ParseException {
        List children = clock.getChildren();
        CTFClock ctfClock = new CTFClock();
        for (CommonTree child : children) {
            String key = child.getChild(0).getChild(0).getChild(0).getText();
            CommonTree value = (CommonTree)child.getChild(1).getChild(0).getChild(0);
            int type = value.getType();
            String text = value.getText();
            switch (type) {
                case 20: 
                case 99: {
                    Long numValue;
                    try {
                        numValue = Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        Activator.log(2, "Number conversion issue with " + text + ". Assigning " + key + " = 0.");
                        numValue = 0L;
                    }
                    ctfClock.addAttribute(key, numValue);
                    break;
                }
                default: {
                    ctfClock.addAttribute(key, text);
                }
            }
        }
        return ctfClock;
    }
}

