/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPASTFunctionCallExpression
extends ASTNode
implements ICPPASTFunctionCallExpression,
IASTAmbiguityParent {
    private ICPPASTExpression fFunctionName;
    private IASTInitializerClause[] fArguments;
    private IASTImplicitName[] fImplicitNames;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;

    public CPPASTFunctionCallExpression() {
        this.setArguments(null);
    }

    public CPPASTFunctionCallExpression(IASTExpression functionName, IASTInitializerClause[] args) {
        this.setFunctionNameExpression(functionName);
        this.setArguments(args);
    }

    @Override
    public CPPASTFunctionCallExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTFunctionCallExpression copy(IASTNode.CopyStyle style) {
        IASTInitializerClause[] args = null;
        if (this.fArguments.length > 0) {
            args = new IASTInitializerClause[this.fArguments.length];
            int i = 0;
            while (i < this.fArguments.length) {
                args[i] = this.fArguments[i].copy(style);
                ++i;
            }
        }
        CPPASTFunctionCallExpression copy = new CPPASTFunctionCallExpression(null, args);
        copy.setFunctionNameExpression(this.fFunctionName == null ? null : this.fFunctionName.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getFunctionNameExpression() {
        return this.fFunctionName;
    }

    @Override
    public void setFunctionNameExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fFunctionName = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FUNCTION_NAME);
        }
    }

    @Override
    public IASTInitializerClause[] getArguments() {
        return this.fArguments;
    }

    @Override
    public void setArguments(IASTInitializerClause[] arguments) {
        this.assertNotFrozen();
        if (arguments == null) {
            this.fArguments = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        } else {
            this.fArguments = arguments;
            IASTInitializerClause[] iASTInitializerClauseArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                arg.setParent(this);
                arg.setPropertyInParent(ARGUMENT);
                ++n2;
            }
        }
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            CPPASTImplicitName n2;
            CPPASTImplicitName n1;
            block11: {
                ICPPFunction overload = this.getOverload();
                if (overload == null) {
                    this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                    return IASTImplicitName.EMPTY_NAME_ARRAY;
                }
                if (this.getEvaluation() instanceof EvalTypeId) {
                    CPPASTImplicitName n12 = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
                    n12.setOffsetAndLength((ASTNode)((Object)this.fFunctionName));
                    n12.setBinding(overload);
                    this.fImplicitNames = new IASTImplicitName[]{n12};
                    return this.fImplicitNames;
                }
                if (overload instanceof CPPImplicitFunction && (!(overload instanceof ICPPMethod) || ((ICPPMethod)overload).isImplicit())) {
                    this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                    return IASTImplicitName.EMPTY_NAME_ARRAY;
                }
                n1 = new CPPASTImplicitName(OverloadableOperator.PAREN, (IASTNode)this);
                n1.setBinding(overload);
                n2 = new CPPASTImplicitName(OverloadableOperator.PAREN, (IASTNode)this);
                n2.setBinding(overload);
                n2.setAlternate(true);
                if (this.fArguments.length == 0) {
                    int idEndOffset = ((ASTNode)((Object)this.fFunctionName)).getOffset() + ((ASTNode)((Object)this.fFunctionName)).getLength();
                    try {
                        IToken lparen = this.fFunctionName.getTrailingSyntax();
                        IToken rparen = lparen.getNext();
                        if (lparen.getType() == 8) {
                            n1.setOffsetAndLength(idEndOffset + lparen.getOffset(), 1);
                        } else {
                            n1.setOffsetAndLength(idEndOffset + lparen.getEndOffset(), 0);
                        }
                        if (rparen.getType() == 9) {
                            n2.setOffsetAndLength(idEndOffset + rparen.getOffset(), 1);
                            break block11;
                        }
                        n2.setOffsetAndLength(idEndOffset + rparen.getEndOffset(), 0);
                    }
                    catch (ExpansionOverlapsBoundaryException e) {
                        n1.setOffsetAndLength(idEndOffset, 0);
                        n2.setOffsetAndLength(idEndOffset, 0);
                    }
                } else {
                    n1.computeOperatorOffsets(this.fFunctionName, true);
                    n2.computeOperatorOffsets(this.fArguments[this.fArguments.length - 1], true);
                }
            }
            this.fImplicitNames = new IASTImplicitName[]{n1, n2};
        }
        return this.fImplicitNames;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTImplicitName[] implicits;
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fFunctionName != null && !this.fFunctionName.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null && implicits.length > 0 && !implicits[0].accept(action)) {
            return false;
        }
        IASTInitializerClause[] iASTInitializerClauseArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (!arg.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (implicits != null && implicits.length > 1 && !implicits[1].accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTFunctionCallExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fFunctionName) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fFunctionName = (ICPPASTExpression)other;
        }
        int i = 0;
        while (i < this.fArguments.length) {
            if (child == this.fArguments[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.fArguments[i] = (IASTExpression)other;
            }
            ++i;
        }
    }

    @Override
    public ICPPFunction getOverload() {
        IType t;
        ICPPEvaluation eval = this.getEvaluation();
        if (eval instanceof EvalFunctionCall) {
            return ((EvalFunctionCall)eval).getOverload(this);
        }
        if (eval instanceof EvalTypeId && !eval.isTypeDependent() && (t = SemanticUtil.getNestedType(((EvalTypeId)eval).getInputType(), 13)) instanceof ICPPClassType && !(t instanceof ICPPUnknownBinding)) {
            ICPPClassType cls = (ICPPClassType)t;
            LookupData data = CPPSemantics.createLookupData(((IASTIdExpression)((Object)this.fFunctionName)).getName());
            try {
                ICPPFunction[] constructors = ClassTypeHelper.getConstructors(cls, data.getLookupPoint());
                IBinding b = CPPSemantics.resolveFunction(data, constructors, true);
                if (b instanceof ICPPFunction) {
                    return (ICPPFunction)b;
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        if (this.fFunctionName == null || this.fArguments == null) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation conversion = this.checkForExplicitTypeConversion();
        if (conversion != null) {
            return conversion;
        }
        ICPPEvaluation[] args = new ICPPEvaluation[this.fArguments.length + 1];
        args[0] = this.fFunctionName.getEvaluation();
        int i = 1;
        while (i < args.length) {
            args[i] = ((ICPPASTInitializerClause)this.fArguments[i - 1]).getEvaluation();
            ++i;
        }
        return new EvalFunctionCall(args, this);
    }

    private ICPPEvaluation checkForExplicitTypeConversion() {
        IASTName name;
        IBinding b;
        if (this.fFunctionName instanceof IASTIdExpression && (b = (name = ((IASTIdExpression)((Object)this.fFunctionName)).getName()).resolvePreBinding()) instanceof IType) {
            ICPPEvaluation[] args = new ICPPEvaluation[this.fArguments.length];
            int i = 0;
            while (i < args.length) {
                args[i] = ((ICPPASTInitializerClause)this.fArguments[i]).getEvaluation();
                ++i;
            }
            return new EvalTypeId((IType)((Object)b), this, args);
        }
        return null;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getType(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

