/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation;

import java.util.Collection;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation.CSourceTag;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation.ISourceTag;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation.ISourceTagListener;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation.ISourceTagProvider;
import org.eclipse.core.runtime.ListenerList;

public class CSourceTagProvider
implements ISourceTagProvider {
    private ListenerList fListenerList = new ListenerList(1);
    private ITranslationUnit fUnit;

    public CSourceTagProvider(ITranslationUnit unit) {
        this.fUnit = unit;
    }

    @Override
    public void addSourceTagListener(ISourceTagListener listener) {
        this.fListenerList.add((Object)listener);
    }

    @Override
    public int[] getActiveCodePositions() {
        return null;
    }

    @Override
    public long getSnapshotTime() {
        return 0L;
    }

    @Override
    public void getSourceTags(Collection<ISourceTag> target) {
        try {
            this.convertToSourceTags(this.fUnit.getChildren(), target);
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    private ISourceTag convertToSourceTag(ICElement element) {
        if (element instanceof ISourceReference) {
            return new CSourceTag((ISourceReference)element, element.getElementType());
        }
        return null;
    }

    private void convertToSourceTags(ICElement[] children, Collection<ISourceTag> target) throws CModelException {
        int i = 0;
        while (i < children.length) {
            ICElement element = children[i];
            ISourceTag tag = this.convertToSourceTag(element);
            if (tag != null) {
                target.add(tag);
            }
            if (element instanceof IParent) {
                this.convertToSourceTags(((IParent)element).getChildren(), target);
            }
            ++i;
        }
    }

    @Override
    public void removeSourceTagListener(ISourceTagListener listener) {
        this.fListenerList.remove((Object)listener);
    }
}

