/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.ui;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.profiling.ui.BooleanWithGetSet;
import org.eclipse.linuxtools.profiling.ui.MessageDialogSyncedRunnable;
import org.eclipse.linuxtools.profiling.ui.ProfilingMessages;
import org.eclipse.swt.widgets.Display;

public class CProjectBuildHelpers {
    public static ProjectBuildType getProjectType(IProject project) {
        if (CProjectBuildHelpers.isAutoTools(project)) {
            return ProjectBuildType.AUTO_TOOLS;
        }
        IConfiguration defaultConfiguration = CProjectBuildHelpers.helperGetActiveConfiguration(project);
        IBuilder builder = defaultConfiguration.getBuilder();
        Boolean projIsManaged = builder.isManagedBuildOn();
        if (projIsManaged.booleanValue()) {
            return ProjectBuildType.MANAGED_MAKEFILE;
        }
        return ProjectBuildType.OTHER;
    }

    public static boolean isCppType(IProject project) {
        try {
            return project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException ex) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetProjectType);
            return false;
        }
    }

    public static boolean isCType(IProject project) {
        try {
            return project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException e) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetProjectType);
            return false;
        }
    }

    public static boolean isAutoTools(IProject project) {
        try {
            return project.hasNature("org.eclipse.cdt.autotools.core.autotoolsNatureV2");
        }
        catch (CoreException e) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetProjectType);
            return false;
        }
    }

    public static boolean isOptionCheckedInCDT(IProject project, String optionIDString) {
        String toolSuperclassId = CProjectBuildHelpers.helperGetToolSuperClassId(project);
        if (toolSuperclassId == null) {
            return false;
        }
        return CProjectBuildHelpers.isOptionCheckedInCDTTool(project, optionIDString, toolSuperclassId);
    }

    private static boolean isOptionCheckedInCDTTool(IProject project, String optionIDString, String toolSuperClassId) {
        IConfiguration activeConf = CProjectBuildHelpers.helperGetActiveConfiguration(project);
        ITool gccCompileriTool = CProjectBuildHelpers.helperGetGccCompilerToolBySuperClass(toolSuperClassId, activeConf);
        IOption optionTemplate = gccCompileriTool.getOptionById(optionIDString);
        if (optionTemplate == null) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetOptionTemplate);
            return false;
        }
        try {
            IOption mutableOptionToSet = gccCompileriTool.getOptionToSet(optionTemplate, false);
            return (Boolean)mutableOptionToSet.getValue();
        }
        catch (BuildException e) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetOptionForWriting);
            return false;
        }
    }

    public static boolean setOptionInCDT(IProject project, String optionIDString, boolean value) {
        String toolSuperClassId = CProjectBuildHelpers.helperGetToolSuperClassId(project);
        if (toolSuperClassId == null) {
            return false;
        }
        return CProjectBuildHelpers.setOptionInCDTTool(project, optionIDString, value, toolSuperClassId);
    }

    private static boolean setOptionInCDTTool(IProject project, String optionIDString, boolean value, String toolSuperClassId) {
        IConfiguration activeConf = CProjectBuildHelpers.helperGetActiveConfiguration(project);
        ITool gccCompileriTool = CProjectBuildHelpers.helperGetGccCompilerToolBySuperClass(toolSuperClassId, activeConf);
        IOption optionTemplate = gccCompileriTool.getOptionById(optionIDString);
        if (optionTemplate == null) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetOptionTemplate);
            return false;
        }
        IOption mutableOptionToSet = null;
        try {
            mutableOptionToSet = gccCompileriTool.getOptionToSet(optionTemplate, false);
            mutableOptionToSet.setValue(value);
        }
        catch (BuildException e) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetOptionForWriting);
        }
        IResourceInfo resourceInfo = activeConf.getResourceInfos()[0];
        ManagedBuildManager.setOption((IResourceInfo)resourceInfo, (IHoldsOptions)gccCompileriTool, (IOption)mutableOptionToSet, (boolean)true);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        return true;
    }

    public static boolean isOptionCheckedInAutotoolsPrefStore(IProject project, String optionId) {
        BooleanWithGetSet userChoiceBool = new BooleanWithGetSet(false);
        Display.getDefault().syncExec(() -> {
            AutotoolsConfigurationManager.getInstance().syncConfigurations(project);
            ICConfigurationDescription cfgds = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
            if (cfgds != null) {
                IAConfiguration iaConfig = AutotoolsConfigurationManager.getInstance().getConfiguration(project, cfgds.getId());
                IConfigureOption option = iaConfig.getOption(optionId);
                String optValString = option.getValue();
                boolean optVal = Boolean.parseBoolean(optValString);
                userChoiceBool.setVal(optVal);
            }
        });
        return userChoiceBool.getVal();
    }

    public static void setOptionInAutotools(IProject project, String optId, String optVal) {
        Display.getDefault().syncExec(() -> {
            AutotoolsConfigurationManager.getInstance().syncConfigurations(project);
            ICConfigurationDescription cfgds = CoreModel.getDefault().getProjectDescription(project).getActiveConfiguration();
            if (cfgds != null) {
                IAConfiguration iaConfig = AutotoolsConfigurationManager.getInstance().getConfiguration(project, cfgds.getId());
                iaConfig.setOption(optId, optVal);
                AutotoolsConfigurationManager.getInstance().saveConfigs(project);
            }
        });
    }

    public static void rebuildProject(IProject project) {
        try {
            IBuildConfiguration buildConfiguration = project.getActiveBuildConfig();
            project.build(buildConfiguration, 6, null);
        }
        catch (CoreException e) {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorRebuilding);
        }
    }

    private static IConfiguration helperGetActiveConfiguration(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        return buildInfo.getDefaultConfiguration();
    }

    private static String helperGetToolSuperClassId(IProject project) {
        String superClassId = null;
        if (CProjectBuildHelpers.isCType(project)) {
            superClassId = "cdt.managedbuild.tool.gnu.c.compiler";
        } else if (CProjectBuildHelpers.isCppType(project)) {
            superClassId = "cdt.managedbuild.tool.gnu.cpp.compiler";
        } else {
            MessageDialogSyncedRunnable.openErrorSyncedRunnable(ProfilingMessages.errorTitle, ProfilingMessages.errorGetProjectToolname);
            return null;
        }
        return superClassId;
    }

    private static ITool helperGetGccCompilerToolBySuperClass(String superClassId, IConfiguration activeConf) {
        ITool[] tools = activeConf.getTools();
        ITool gccCompileriTool = null;
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool iTool;
            ITool tool = iTool = iToolArray[n2];
            while (tool.getSuperClass() != null) {
                tool = tool.getSuperClass();
            }
            if (tool.getId().equals(superClassId)) {
                gccCompileriTool = iTool;
                break;
            }
            ++n2;
        }
        return gccCompileriTool;
    }

    public static enum ProjectBuildType {
        AUTO_TOOLS,
        MANAGED_MAKEFILE,
        OTHER;

    }
}

