/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.CoreNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTree;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    private final @NonNull String fSsid;
    private final @NonNull HistoryTree fSht;
    private volatile boolean fFinishedBuilding = false;

    protected boolean isFinishedBuilding() {
        return this.fFinishedBuilding;
    }

    protected void setFinishedBuilding(boolean isFinishedBuilding) {
        this.fFinishedBuilding = isFinishedBuilding;
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime, int blockSize, int maxChildren) throws IOException {
        this.fSsid = ssid;
        HTConfig conf = new HTConfig(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.fSht = this.initializeSHT(conf);
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime) throws IOException {
        this(ssid, newStateFile, providerVersion, startTime, 65536, 50);
    }

    public HistoryTreeBackend(@NonNull String ssid, @NonNull File existingStateFile, int providerVersion) throws IOException {
        this.fSsid = ssid;
        this.fSht = this.initializeSHT(existingStateFile, providerVersion);
        this.fFinishedBuilding = true;
    }

    @VisibleForTesting
    protected @NonNull HistoryTree initializeSHT(@NonNull HTConfig conf) throws IOException {
        return HistoryTreeFactory.createHistoryTree(conf);
    }

    @VisibleForTesting
    protected @NonNull HistoryTree initializeSHT(@NonNull File existingStateFile, int providerVersion) throws IOException {
        return HistoryTreeFactory.createFromFile(existingStateFile.toPath(), providerVersion);
    }

    protected final @NonNull HistoryTree getSHT() {
        return this.fSht;
    }

    @Override
    public String getSSID() {
        return this.fSsid;
    }

    @Override
    public long getStartTime() {
        return this.getSHT().getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.getSHT().getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        this.getSHT().insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.getSHT().closeTree(endTime);
        this.fFinishedBuilding = true;
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.getSHT().supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.getSHT().supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.getSHT().supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.getSHT().deleteFile();
    }

    @Override
    public void dispose() {
        if (this.fFinishedBuilding) {
            this.getSHT().closeFile();
        } else {
            this.getSHT().deleteFile();
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        HTNode currentNode = this.getSHT().getRootNode();
        currentNode.writeInfoFromNode(stateInfo, t);
        try {
            while (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.getSHT().selectNextChild((CoreNode)currentNode, t);
                currentNode.writeInfoFromNode(stateInfo, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        return this.getRelevantInterval(t, attributeQuark);
    }

    private void checkValidTime(long t) {
        long startTime = this.getStartTime();
        long endTime = this.getEndTime();
        if (t < startTime || t > endTime) {
            throw new TimeRangeException(String.format("%s Time:%d, Start:%d, End:%d", this.fSsid, t, startTime, endTime));
        }
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        HTNode currentNode = this.getSHT().getRootNode();
        HTInterval interval = currentNode.getRelevantInterval(key, t);
        try {
            while (interval == null && currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.getSHT().selectNextChild((CoreNode)currentNode, t);
                interval = currentNode.getRelevantInterval(key, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
        return interval;
    }

    public long getFileSize() {
        return this.getSHT().getFileSize();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.getSHT().getNodeCount()) {
                HTNode node = this.getSHT().readNode(seq);
                total += node.getNodeUsagePercent();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        long ret = total / (long)this.getSHT().getNodeCount();
        if (ret < 0L || ret > 100L) {
            throw new IllegalStateException("Average node usage is not a percentage: " + ret);
        }
        return (int)ret;
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        this.debugPrint(writer, false, -1L);
    }

    public void debugPrint(PrintWriter writer, boolean printIntervals, long ts) {
        writer.println("------------------------------");
        writer.println("State History Tree:\n");
        writer.println(this.getSHT().toString());
        writer.println("Average node utilization: " + this.getAverageNodeUsage());
        writer.println("");
        this.getSHT().debugPrintFullTree(writer, printIntervals, ts);
    }
}

