/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.aggregator;

import java.math.BigDecimal;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.chart.ui.aggregator.IConsumerAggregator;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.IDataConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.consumer.NumericalConsumer;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRange;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRangeMap;

public class NumericalConsumerAggregator
implements IConsumerAggregator {
    private @Nullable BigDecimal fMinimum;
    private @Nullable BigDecimal fMaximum;

    @Override
    public void accept(IDataConsumer obj) {
        NumericalConsumer consumer = (NumericalConsumer)obj;
        BigDecimal nextMin = new BigDecimal(consumer.getMin().toString());
        BigDecimal nextMax = new BigDecimal(consumer.getMax().toString());
        BigDecimal min = this.fMinimum;
        BigDecimal max = this.fMaximum;
        if (min == null || max == null) {
            this.fMinimum = nextMin;
            this.fMaximum = nextMax;
            return;
        }
        this.fMinimum = min.min(nextMin);
        this.fMaximum = max.max(nextMax);
    }

    public ChartRangeMap getChartRanges() {
        BigDecimal min = this.fMinimum;
        BigDecimal max = this.fMaximum;
        if (min == null || max == null) {
            return new ChartRangeMap();
        }
        ChartRange external = new ChartRange(min, max);
        return new ChartRangeMap(external);
    }
}

