/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.gdbtrace.core.trace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.internal.gdbtrace.core.event.GdbTraceEvent;
import org.eclipse.tracecompass.internal.gdbtrace.core.trace.DsfGdbAdaptor;
import org.eclipse.tracecompass.internal.gdbtrace.core.trace.GdbEventAspects;
import org.eclipse.tracecompass.internal.gdbtrace.core.trace.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public class GdbTrace
extends TmfTrace {
    private static final int CACHE_SIZE = 20;
    private static final byte[] HEADER = new byte[]{127, 84, 82, 65, 67, 69};
    public static final QualifiedName EXEC_KEY = new QualifiedName("org.eclipse.tracecompass.gdbtrace.core", "executable");
    private DsfGdbAdaptor fGdbTpRef;
    private long fNbFrames = 0L;
    long fLocation;

    public GdbTrace() {
        this.setCacheSize(20);
    }

    public IStatus validate(IProject project, String path) {
        block14: {
            File file = new File(path);
            if (!file.exists()) {
                return new Status(4, "org.eclipse.tracecompass.gdbtrace.core", NLS.bind((String)Messages.GdbTrace_FileNotFound, (Object)path));
            }
            if (!file.isFile()) {
                return new Status(4, "org.eclipse.tracecompass.gdbtrace.core", NLS.bind((String)Messages.GdbTrace_GdbTracesMustBeAFile, (Object)path));
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    byte[] buffer = new byte[HEADER.length];
                    int read = stream.read(buffer);
                    if (read == HEADER.length && Arrays.equals(buffer, HEADER)) break block14;
                    return new Status(4, "org.eclipse.tracecompass.gdbtrace.core", NLS.bind((String)Messages.GdbTrace_NotGdbTraceFile, (Object)path));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.tracecompass.gdbtrace.core", NLS.bind((String)Messages.GdbTrace_IOException, (Object)path), (Throwable)e);
            }
        }
        return new TraceValidationStatus(100, "org.eclipse.tracecompass.gdbtrace.core");
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        try {
            String tracedExecutable = resource.getPersistentProperty(EXEC_KEY);
            if (tracedExecutable == null) {
                throw new TmfTraceException(Messages.GdbTrace_ExecutableNotSet);
            }
            String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
            this.fGdbTpRef = new DsfGdbAdaptor(this, defaultGdbCommand, path, tracedExecutable);
            this.fNbFrames = this.getNbFrames();
        }
        catch (CoreException e) {
            throw new TmfTraceException(Messages.GdbTrace_FailedToInitializeTrace, (Throwable)e);
        }
        super.initTrace(resource, path, type);
    }

    public synchronized void dispose() {
        if (this.fGdbTpRef != null) {
            this.fGdbTpRef.dispose();
        }
        super.dispose();
    }

    public String getDsfSessionId() {
        return this.fGdbTpRef.getSessionId();
    }

    public synchronized long getNbFrames() {
        this.fNbFrames = this.fGdbTpRef.getNumberOfFrames();
        return this.fNbFrames;
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return GdbEventAspects.getAspects();
    }

    public synchronized TmfContext seekEvent(ITmfLocation location) {
        this.fLocation = location != null ? (Long)location.getLocationInfo() : 0L;
        return new TmfContext((ITmfLocation)new TmfLongLocation(this.fLocation), this.fLocation);
    }

    public synchronized ITmfContext seekEvent(double ratio) {
        TmfContext context = this.seekEvent((long)ratio * this.getNbEvents());
        return context;
    }

    public double getLocationRatio(ITmfLocation location) {
        if (this.getNbEvents() > 0L && location instanceof TmfLongLocation) {
            return (double)((TmfLongLocation)location).getLocationInfo().longValue() / (double)this.getNbEvents();
        }
        return 0.0;
    }

    public ITmfLocation getCurrentLocation() {
        return new TmfLongLocation(this.fLocation);
    }

    public GdbTraceEvent parseEvent(ITmfContext context) {
        if (context.getRank() >= this.fNbFrames) {
            return null;
        }
        GdbTraceEvent event = this.fGdbTpRef.selectAndReadFrame(context.getRank());
        ++this.fLocation;
        return event;
    }

    public synchronized TmfContext seekEvent(ITmfTimestamp timestamp) {
        long rank = timestamp.getValue();
        return this.seekEvent(rank);
    }

    public synchronized TmfContext seekEvent(long rank) {
        this.fLocation = rank;
        TmfContext context = new TmfContext((ITmfLocation)new TmfLongLocation(this.fLocation), rank);
        return context;
    }

    public synchronized void selectFrame(long rank) {
        this.fGdbTpRef.selectDataFrame(rank, true);
    }
}

