/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.VirtualMachineCommon;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.VirtualMachineViewEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class VirtualMachinePresentationProvider
extends TimeGraphPresentationProvider {
    private static final int ALPHA = 70;

    private static State[] getStateValues() {
        return State.values();
    }

    private static State getStateForVcpu(int value) {
        if ((value & 0x100) > 0) {
            return State.VCPU_PREEMPTED;
        }
        if ((value & 0x80) > 0) {
            return State.WAIT_VMM;
        }
        if (value == 2) {
            return State.USERMODE;
        }
        if (value == 1) {
            return State.IDLE;
        }
        return State.UNKNOWN;
    }

    private static @Nullable State getStateForThread(int value) {
        if (value == 256) {
            return null;
        }
        switch (value) {
            case 2: {
                return State.THREAD_USERMODE;
            }
            case 3: {
                return State.THREAD_SYSCALL;
            }
            case 5: {
                return State.THREAD_WAIT_FOR_CPU;
            }
            case 1: {
                return State.THREAD_WAIT_BLOCKED;
            }
            case 4: {
                return State.THREAD_INTERRUPTED;
            }
            case 0: 
            case 6: {
                return State.THREAD_UNKNOWN;
            }
        }
        return null;
    }

    private static @Nullable State getEventState(TimeEvent event) {
        if (event.hasValue()) {
            VirtualMachineViewEntry entry = (VirtualMachineViewEntry)event.getEntry();
            int value = event.getValue();
            if (entry.getType() == VirtualMachineCommon.Type.VCPU) {
                return VirtualMachinePresentationProvider.getStateForVcpu(value);
            }
            if (entry.getType() == VirtualMachineCommon.Type.THREAD) {
                return VirtualMachinePresentationProvider.getStateForThread(value);
            }
        }
        return null;
    }

    public int getStateTableIndex(@Nullable ITimeEvent event) {
        if (event == null) {
            return -2;
        }
        State state = VirtualMachinePresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.ordinal();
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        State[] states = VirtualMachinePresentationProvider.getStateValues();
        StateItem[] stateTable = new StateItem[states.length];
        int i = 0;
        while (i < stateTable.length) {
            State state = states[i];
            stateTable[i] = new StateItem(state.fRgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public @Nullable String getEventName(@Nullable ITimeEvent event) {
        if (event == null) {
            return null;
        }
        State state = VirtualMachinePresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.toString();
        }
        if (event instanceof NullTimeEvent) {
            return null;
        }
        return Messages.VmView_multipleStates;
    }

    public void postDrawEvent(@Nullable ITimeEvent event, @Nullable Rectangle bounds, @Nullable GC gc) {
        int value;
        VirtualMachineViewEntry entry;
        boolean visible;
        if (bounds == null || gc == null || !(event instanceof TimeEvent)) {
            return;
        }
        boolean bl = visible = bounds.width != 0;
        if (!visible) {
            return;
        }
        TimeEvent ev = (TimeEvent)event;
        if (ev.hasValue() && (entry = (VirtualMachineViewEntry)event.getEntry()).getType() == VirtualMachineCommon.Type.THREAD && ((value = ev.getValue()) & 0x100) != 0) {
            Color alphaColor = Display.getDefault().getSystemColor(3);
            int alpha = gc.getAlpha();
            Color background = gc.getBackground();
            gc.setBackground(alphaColor);
            gc.setAlpha(70);
            gc.fillRectangle(bounds);
            gc.setBackground(background);
            gc.setAlpha(alpha);
        }
    }

    private static enum State {
        UNKNOWN(new RGB(100, 100, 100)),
        IDLE(new RGB(200, 200, 200)),
        USERMODE(new RGB(0, 200, 0)),
        WAIT_VMM(new RGB(200, 0, 0)),
        VCPU_PREEMPTED(new RGB(120, 40, 90)),
        THREAD_UNKNOWN(new RGB(100, 100, 100)),
        THREAD_WAIT_BLOCKED(new RGB(200, 200, 0)),
        THREAD_WAIT_FOR_CPU(new RGB(200, 100, 0)),
        THREAD_USERMODE(new RGB(0, 200, 0)),
        THREAD_SYSCALL(new RGB(0, 0, 200)),
        THREAD_INTERRUPTED(new RGB(200, 0, 100));

        private final RGB fRgb;

        private State(RGB rgb) {
            this.fRgb = rgb;
        }
    }
}

