/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SystemProfileForm
implements Listener {
    protected Label profileLabel;
    protected Control verbiage;
    protected Text profileName;
    protected ISystemMessageLine msgLine;
    protected ISystemValidator nameValidator;
    protected Object caller;
    protected boolean callerInstanceOfWizardPage;
    protected boolean callerInstanceOfSystemPromptDialog;
    protected static final int profileNameLength = 100;
    protected ISystemProfile profile;
    private boolean showVerbiage = true;
    private SystemMessage errorMessage = null;

    public SystemProfileForm(ISystemMessageLine msgLine, Object caller, ISystemProfile profile, boolean showVerbiage) {
        this.msgLine = msgLine;
        this.caller = caller;
        this.profile = profile;
        this.showVerbiage = showVerbiage;
        this.callerInstanceOfWizardPage = caller instanceof WizardPage;
        this.callerInstanceOfSystemPromptDialog = caller instanceof SystemPromptDialog;
        this.nameValidator = ValidatorFactory.getProfileNameValidator(profile.getName());
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
    }

    public void setNameValidators(ISystemValidator v) {
        this.nameValidator = v;
    }

    public void setProfileName(String name) {
        if (name != null && this.profileName != null) {
            this.profileName.setText(name);
        }
    }

    public Control createContents(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        if (this.showVerbiage) {
            this.verbiage = SystemWidgetHelpers.createVerbiage(composite_prompts, SystemResources.RESID_PROFILE_PROFILENAME_VERBIAGE, nbrColumns, false, 200);
            SystemWidgetHelpers.createLabel(composite_prompts, "", nbrColumns);
        }
        String temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_PROFILE_PROFILENAME_LABEL);
        this.profileLabel = SystemWidgetHelpers.createLabel(composite_prompts, temp);
        this.profileName = SystemWidgetHelpers.createTextField(composite_prompts, this, SystemResources.RESID_PROFILE_PROFILENAME_TIP);
        this.profileName.setTextLimit(100);
        if (this.profile != null) {
            this.profileName.setText(this.profile.getName());
        }
        this.profileName.setFocus();
        this.profileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemProfileForm.this.validateNameInput();
            }
        });
        return composite_prompts;
    }

    public Control getInitialFocusControl() {
        return this.profileName;
    }

    public void handleEvent(Event evt) {
    }

    public boolean verify() {
        SystemMessage errMsg = null;
        Text controlInError = null;
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        }
        if ((errMsg = this.validateNameInput()) != null) {
            controlInError = this.profileName;
            controlInError.setFocus();
            this.showErrorMessage(errMsg);
        }
        return errMsg == null;
    }

    public String getProfileName() {
        return this.profileName.getText().trim();
    }

    private void showErrorMessage(SystemMessage msg) {
        if (this.msgLine != null) {
            if (msg != null) {
                this.msgLine.setErrorMessage(msg);
            } else {
                this.msgLine.clearErrorMessage();
            }
        } else {
            System.out.println("MSGLINE NULL. TRYING TO WRITE MSG " + msg);
        }
    }

    protected SystemMessage validateNameInput() {
        this.errorMessage = null;
        this.errorMessage = this.nameValidator.validate(this.profileName.getText().trim());
        this.showErrorMessage(this.errorMessage);
        this.setPageComplete();
        return this.errorMessage;
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.errorMessage == null) {
            pageComplete = this.getProfileName().length() > 0;
        }
        return pageComplete;
    }

    public void setPageComplete() {
        boolean complete = this.isPageComplete();
        if (this.callerInstanceOfWizardPage) {
            ((WizardPage)this.caller).setPageComplete(complete);
        } else if (this.callerInstanceOfSystemPromptDialog) {
            ((SystemPromptDialog)this.caller).setPageComplete(complete);
        }
    }
}

