/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.trace;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfThreadSelectedSignal;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceModelSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;

public class LinuxTraceContext
extends TmfTraceContext {
    public static final int INVALID_CPU = -1;
    public static final int INVALID_THREAD_ID = -1;
    private int fCpu = -1;
    private int fTid = -1;
    private final ITmfTrace fTrace;

    public LinuxTraceContext(TmfTimeRange selection, TmfTimeRange windowRange, @Nullable IFile editorFile, @Nullable ITmfFilter filter, ITmfTrace trace) {
        super(selection, windowRange, editorFile, filter);
        this.fTrace = trace;
    }

    public void receive(@NonNull TmfTraceModelSignal signal) {
        if (signal.getHostId().equals(this.fTrace.getHostId())) {
            if (signal instanceof TmfThreadSelectedSignal) {
                this.fTid = ((TmfThreadSelectedSignal)signal).getThreadId();
            } else if (signal instanceof TmfCpuSelectedSignal) {
                this.fCpu = ((TmfCpuSelectedSignal)signal).getCore();
            }
        }
    }

    public int getCpu() {
        return this.fCpu;
    }

    public int getTid() {
        return this.fTid;
    }
}

