/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue;

import com.google.common.annotations.VisibleForTesting;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferReader;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferWriter;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public abstract class CustomStateValue
extends TmfStateValue {
    private static final int MIN_SIZE = 1;
    private static final CustomStateValueFactory[] CUSTOM_FACTORIES = new CustomStateValueFactory[256];

    public static void registerCustomFactory(byte customId, CustomStateValueFactory factory) {
        if (customId >= 0 && customId <= 20) {
            throw new IllegalArgumentException("State value IDs between 0 and 20 are reserved for built-in state value types");
        }
        CustomStateValueFactory currentFactory = CUSTOM_FACTORIES[customId - -128];
        if (currentFactory == null) {
            CustomStateValue.CUSTOM_FACTORIES[customId - -128] = factory;
        } else if (currentFactory != factory) {
            throw new IllegalStateException("Already a custom factory registered for " + Byte.toString(customId));
        }
    }

    @VisibleForTesting
    protected static void unregisterCustomFactory(byte customId) {
        CustomStateValue.CUSTOM_FACTORIES[customId - -128] = null;
    }

    public static @Nullable CustomStateValueFactory getCustomFactory(byte customId) {
        return CUSTOM_FACTORIES[customId - -128];
    }

    public static TmfStateValue readSerializedValue(ISafeByteBufferReader buffer) {
        byte customType = buffer.get();
        CustomStateValueFactory customFactory = CustomStateValue.getCustomFactory(customType);
        if (customFactory == null) {
            Activator.getDefault().logWarning("Custom factory for type " + customType + " does not exist");
            return TmfStateValue.nullValue();
        }
        return customFactory.readCustomValue(buffer);
    }

    protected abstract Byte getCustomTypeId();

    protected abstract void serializeValue(ISafeByteBufferWriter var1);

    protected abstract int getSerializedValueSize();

    public final void serialize(ISafeByteBufferWriter buffer) {
        buffer.put(this.getCustomTypeId());
        this.serializeValue(buffer);
    }

    public final int getSerializedSize() {
        int size = this.getSerializedValueSize();
        if (size > 32766) {
            throw new ArrayIndexOutOfBoundsException("Serialized state value is larger than the maximum allowed size of 32766: " + size);
        }
        return size + 1;
    }

    @Override
    public final ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.CUSTOM;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @FunctionalInterface
    public static interface CustomStateValueFactory {
        public CustomStateValue readCustomValue(ISafeByteBufferReader var1);
    }
}

