/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.osview;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.ResourceClassContributionItem;
import org.eclipse.jface.dialogs.IDialogSettings;

class ColumnLayout {
    private String fResourceClass;
    private Map<String, Boolean> fVisible = new HashMap<String, Boolean>();
    private Map<String, Integer> fWidth = new HashMap<String, Integer>();
    private Integer fSortColumn = null;
    private Integer fSortDirection = null;
    private static IDialogSettings settings;

    private static IDialogSettings getDialogSettings() {
        if (settings != null) {
            return settings;
        }
        IDialogSettings topSettings = GdbUIPlugin.getDefault().getDialogSettings();
        settings = topSettings.getSection(ResourceClassContributionItem.class.getName());
        if (settings == null) {
            settings = topSettings.addNewSection(ResourceClassContributionItem.class.getName());
        }
        return settings;
    }

    private static void setDefaultSetting(String key, boolean value) {
        IDialogSettings s = ColumnLayout.getDialogSettings();
        if (s.get(key) == null) {
            s.put(key, value);
        }
    }

    private static void setDefaultSetting(String key, int value) {
        IDialogSettings s = ColumnLayout.getDialogSettings();
        if (s.get(key) == null) {
            s.put(key, value);
        }
    }

    public ColumnLayout(String resourceClass) {
        this.fResourceClass = resourceClass;
    }

    public boolean getVisible(String column) {
        if (this.fVisible.containsKey(column)) {
            return this.fVisible.get(column);
        }
        ColumnLayout.setDefaultSetting(this.columnKey(column, "v"), true);
        boolean b = ColumnLayout.getDialogSettings().getBoolean(this.columnKey(column, "v"));
        this.fVisible.put(column, b);
        return b;
    }

    public void setVisible(String column, boolean visible) {
        this.fVisible.put(column, visible);
        ColumnLayout.getDialogSettings().put(this.columnKey(column, "v"), visible);
    }

    public int getWidth(String column) {
        if (this.fWidth.containsKey(column)) {
            return this.fWidth.get(column);
        }
        ColumnLayout.setDefaultSetting(this.columnKey(column, "w"), -1);
        int w = ColumnLayout.getDialogSettings().getInt(this.columnKey(column, "w"));
        this.fWidth.put(column, w);
        return w;
    }

    public void setWidth(String column, int width) {
        this.fWidth.put(column, width);
        ColumnLayout.getDialogSettings().put(this.columnKey(column, "w"), width);
    }

    public int getSortColumn() {
        if (this.fSortColumn == null) {
            ColumnLayout.setDefaultSetting(this.globalKey("sortColumn"), 0);
            this.fSortColumn = ColumnLayout.getDialogSettings().getInt(this.globalKey("sortColumn"));
        }
        return this.fSortColumn;
    }

    public void setSortColumn(int column) {
        this.fSortColumn = column;
        ColumnLayout.getDialogSettings().put(this.globalKey("sortColumn"), this.fSortColumn.intValue());
    }

    public int getSortDirection() {
        if (this.fSortDirection == null) {
            ColumnLayout.setDefaultSetting(this.globalKey("sortDirection"), 1);
            this.fSortDirection = ColumnLayout.getDialogSettings().getInt(this.globalKey("sortDirection"));
        }
        return this.fSortDirection;
    }

    public void setSortDirection(int direction) {
        this.fSortDirection = direction;
        ColumnLayout.getDialogSettings().put(this.globalKey("sortDirection"), this.fSortDirection.intValue());
    }

    private String columnKey(String column, String what) {
        return "columnLayout." + this.fResourceClass + "." + column + "." + what;
    }

    private String globalKey(String what) {
        return "columnLayout." + this.fResourceClass + "." + what;
    }
}

