/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.ui.AbstractCDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GDBSolibBlock;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.IMILaunchConfigurationComponent;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.SolibSearchPathBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GdbDebuggerPage
extends AbstractCDebuggerPage
implements Observer {
    protected TabFolder fTabFolder;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    protected Button fNonStopCheckBox;
    protected Button fReverseCheckBox;
    protected Combo fReverseDebugMode;
    protected static final String HW_REVERSE_MODE = LaunchUIMessages.getString("GDBDebuggerPage.reverse_Debuggingmodehard");
    protected static final String SW_REVERSE_MODE = LaunchUIMessages.getString("GDBDebuggerPage.reverse_Debuggingmodesoft");
    protected Button fUpdateThreadlistOnSuspend;
    protected Button fDebugOnFork;
    protected Combo fTracepointModeCombo;
    protected static final String TP_FAST_ONLY = LaunchUIMessages.getString("GDBDebuggerPage.tracepoint_mode_fast");
    protected static final String TP_NORMAL_ONLY = LaunchUIMessages.getString("GDBDebuggerPage.tracepoint_mode_normal");
    protected static final String TP_AUTOMATIC = LaunchUIMessages.getString("GDBDebuggerPage.tracepoint_mode_auto");
    private IMILaunchConfigurationComponent fSolibBlock;
    private boolean fIsInitializing = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(comp, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IPreferenceStore preferenceStore = GdbUIPlugin.getDefault().getPreferenceStore();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", preferenceStore.getString("defaultGdbCommand"));
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", preferenceStore.getString("defaultGdbInit"));
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", preferenceStore.getBoolean("defaultNonStop"));
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE_MODE", "UseSoftTrace");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_ON_FORK", false);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.TRACEPOINT_MODE", "TP_NORMAL_ONLY");
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(LaunchUIMessages.getString("GDBDebuggerPage.gdb_executable_not_specified"));
            this.setMessage(null);
        }
        return valid;
    }

    private String getStringAttr(ILaunchConfiguration config, String attributeName, String defaultValue) {
        try {
            return config.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            return defaultValue;
        }
    }

    private boolean getBooleanAttr(ILaunchConfiguration config, String attributeName, boolean defaultValue) {
        try {
            return config.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            return defaultValue;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        IPreferenceStore preferenceStore = GdbUIPlugin.getDefault().getPreferenceStore();
        String gdbCommand = this.getStringAttr(configuration, "org.eclipse.cdt.dsf.gdb.DEBUG_NAME", preferenceStore.getString("defaultGdbCommand"));
        String gdbInit = this.getStringAttr(configuration, "org.eclipse.cdt.dsf.gdb.GDB_INIT", preferenceStore.getString("defaultGdbInit"));
        boolean nonStopMode = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.NON_STOP", preferenceStore.getBoolean("defaultNonStop"));
        boolean reverseEnabled = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.REVERSE", false);
        this.updateReverseDebugModeFromConfig(configuration);
        boolean updateThreadsOnSuspend = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        boolean debugOnFork = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.DEBUG_ON_FORK", false);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(configuration);
        }
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
        this.fNonStopCheckBox.setSelection(nonStopMode);
        this.fReverseCheckBox.setSelection(reverseEnabled);
        this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
        this.fDebugOnFork.setSelection(debugOnFork);
        this.updateTracepointModeFromConfig(configuration);
        this.setInitializing(false);
    }

    protected void updateTracepointModeFromConfig(ILaunchConfiguration config) {
        if (this.fTracepointModeCombo != null) {
            String tracepointMode = this.getStringAttr(config, "org.eclipse.cdt.dsf.gdb.TRACEPOINT_MODE", "TP_NORMAL_ONLY");
            if (tracepointMode.equals("TP_NORMAL_ONLY")) {
                this.fTracepointModeCombo.setText(TP_NORMAL_ONLY);
            } else if (tracepointMode.equals("TP_FAST_ONLY")) {
                this.fTracepointModeCombo.setText(TP_FAST_ONLY);
            } else if (tracepointMode.equals("TP_FAST_THEN_NORMAL")) {
                this.fTracepointModeCombo.setText(TP_AUTOMATIC);
            } else {
                this.fTracepointModeCombo.setText(TP_NORMAL_ONLY);
            }
        }
    }

    protected void updateReverseDebugModeFromConfig(ILaunchConfiguration config) {
        if (this.fReverseDebugMode != null) {
            String debugMode = this.getStringAttr(config, "org.eclipse.cdt.dsf.gdb.REVERSE_MODE", "UseSoftTrace");
            if (debugMode.equals("UseHardTrace")) {
                this.fReverseDebugMode.setText(HW_REVERSE_MODE);
            } else {
                this.fReverseDebugMode.setText(SW_REVERSE_MODE);
            }
        }
    }

    protected String getSelectedTracepointMode() {
        if (this.fTracepointModeCombo != null) {
            int selectedIndex = this.fTracepointModeCombo.getSelectionIndex();
            if (this.fTracepointModeCombo.getItem(selectedIndex).equals(TP_NORMAL_ONLY)) {
                return "TP_NORMAL_ONLY";
            }
            if (this.fTracepointModeCombo.getItem(selectedIndex).equals(TP_FAST_ONLY)) {
                return "TP_FAST_ONLY";
            }
            if (this.fTracepointModeCombo.getItem(selectedIndex).equals(TP_AUTOMATIC)) {
                return "TP_FAST_THEN_NORMAL";
            }
            assert (false) : "Unknown Tracepoint mode: " + this.fTracepointModeCombo.getItem(selectedIndex);
        }
        return "TP_NORMAL_ONLY";
    }

    protected String getSelectedReverseDebugMode() {
        if (this.fReverseDebugMode != null) {
            int selectedIndex = this.fReverseDebugMode.getSelectionIndex();
            if (this.fReverseDebugMode.getItem(selectedIndex).equals(HW_REVERSE_MODE)) {
                return "UseHardTrace";
            }
            if (this.fReverseDebugMode.getItem(selectedIndex).equals(SW_REVERSE_MODE)) {
                return "UseSoftTrace";
            }
            assert (false) : "Unknown Reverse Debug mode: " + this.fReverseDebugMode.getItem(selectedIndex);
        }
        return "UseSoftTrace";
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.fGDBCommandText.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", this.fGDBInitText.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", this.fNonStopCheckBox.getSelection());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", this.fReverseCheckBox.getSelection());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_ON_FORK", this.fDebugOnFork.getSelection());
        if (this.fTracepointModeCombo != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.TRACEPOINT_MODE", this.getSelectedTracepointMode());
        }
        if (this.fReverseDebugMode != null) {
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE_MODE", this.getSelectedReverseDebugMode());
        }
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(configuration);
        }
    }

    public String getName() {
        return LaunchUIMessages.getString("GDBDebuggerPage.tab_name");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.isInitializing()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public IMILaunchConfigurationComponent createSolibBlock(Composite parent) {
        GDBSolibBlock block = new GDBSolibBlock(new SolibSearchPathBlock(), true, true);
        block.createControl(parent);
        return block;
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(LaunchUIMessages.getString("GDBDebuggerPage.main_tab_name"));
        Composite comp = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        tabItem.setControl((Control)comp);
        this.createGdbContent(comp);
        ControlFactory.createLabel((Composite)comp, (String)LaunchUIMessages.getString("GDBDebuggerPage.cmdfile_warning"), (int)200, (int)-1, (int)64);
        this.fNonStopCheckBox = this.addCheckbox(comp, LaunchUIMessages.getString("GDBDebuggerPage.nonstop_mode"));
        this.createReverseDebugModeCombo(comp);
        this.fUpdateThreadlistOnSuspend = this.addCheckbox(comp, LaunchUIMessages.getString("GDBDebuggerPage.update_thread_list_on_suspend"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fUpdateThreadlistOnSuspend, "org.eclipse.cdt.dsf.gdb.ui.update_threadlist_button_context");
        this.fDebugOnFork = this.addCheckbox(comp, LaunchUIMessages.getString("GDBDebuggerPage.Automatically_debug_forked_processes"));
        this.createTracepointModeCombo(comp);
    }

    private void createGdbContent(Composite comp) {
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        ControlFactory.createLabel((Composite)subComp, (String)LaunchUIMessages.getString("GDBDebuggerPage.gdb_debugger"));
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GdbDebuggerPage.this.isInitializing()) {
                    GdbDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button button = this.createPushButton(subComp, LaunchUIMessages.getString("GDBDebuggerPage.gdb_browse"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GdbDebuggerPage.this.getShell(), 0);
                dialog.setText(LaunchUIMessages.getString("GDBDebuggerPage.gdb_browse_dlg_title"));
                String gdbCommand = GdbDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GdbDebuggerPage.this.fGDBCommandText.setText(res);
            }
        });
        ControlFactory.createLabel((Composite)subComp, (String)LaunchUIMessages.getString("GDBDebuggerPage.gdb_command_file"));
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GdbDebuggerPage.this.isInitializing()) {
                    GdbDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, LaunchUIMessages.getString("GDBDebuggerPage.gdb_cmdfile_browse"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GdbDebuggerPage.this.getShell(), 0);
                dialog.setText(LaunchUIMessages.getString("GDBDebuggerPage.gdb_cmdfile_dlg_title"));
                String gdbCommand = GdbDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GdbDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
    }

    protected void createTracepointModeCombo(Composite parent) {
        Composite subComp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        ControlFactory.createLabel((Composite)subComp, (String)LaunchUIMessages.getString("GDBDebuggerPage.tracepoint_mode_label"));
        this.fTracepointModeCombo = new Combo(subComp, 12);
        this.fTracepointModeCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fTracepointModeCombo.add(TP_NORMAL_ONLY);
        this.fTracepointModeCombo.add(TP_FAST_ONLY);
        this.fTracepointModeCombo.add(TP_AUTOMATIC);
        this.fTracepointModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fTracepointModeCombo.select(0);
    }

    protected void createReverseDebugModeCombo(Composite parent) {
        Composite subComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        subComp.setLayout((Layout)layout);
        subComp.setFont(parent.getFont());
        this.fReverseCheckBox = this.addCheckbox(subComp, LaunchUIMessages.getString("GDBDebuggerPage.reverse_Debugging"));
        this.fReverseDebugMode = new Combo(subComp, 12);
        this.fReverseDebugMode.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fReverseDebugMode.add(HW_REVERSE_MODE);
        this.fReverseDebugMode.add(SW_REVERSE_MODE);
        this.fReverseDebugMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.fReverseDebugMode.select(0);
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(LaunchUIMessages.getString("GDBDebuggerPage.shared_libraries"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        this.fSolibBlock = this.createSolibBlock(comp);
        if (this.fSolibBlock instanceof Observable) {
            ((Observable)((Object)this.fSolibBlock)).addObserver(this);
        }
    }

    private Button addCheckbox(Composite parent, String label) {
        Button button = ControlFactory.createCheckBox((Composite)parent, (String)label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        return button;
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            if (this.fSolibBlock instanceof Observable) {
                ((Observable)((Object)this.fSolibBlock)).deleteObserver(this);
            }
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }
}

