/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ide.IIdePackage;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UI;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.CreateConfigureDialogHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.ILink;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.Links;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ServersPage
extends WizardPage {
    private Collection<IServerDescriptor> servers;
    private IEclipseContext parentContext;
    private DataBindingContext context;
    private UISynchronize uiSynchronize;

    @Inject
    public ServersPage(@Named(value="org.eclipse.epp.logging.aeri.ide.servers") Collection<IServerDescriptor> servers, UISynchronize uiSynchronize, IEclipseContext parentContext) {
        super(ServersPage.class.getName());
        this.servers = servers;
        this.uiSynchronize = uiSynchronize;
        this.parentContext = parentContext;
        this.context = new DataBindingContext();
        this.setPageComplete(false);
        this.setTitle(Formats.format(Messages.WIZPAGE_TITLE_SERVERS, servers.size()));
        this.setDescription(Messages.WIZPAGE_DESCRIPTION_SERVERS);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setPageComplete(true);
            try {
                Method method = Dialog.class.getDeclaredMethod("getButton", Integer.TYPE);
                method.setAccessible(true);
                Button button = (Button)method.invoke((Object)this.getContainer(), 16);
                button.setFocus();
            }
            catch (Exception exception) {}
        }
    }

    public void createControl(Composite parent) {
        int preferredWidth = 400;
        Font font = JFaceResources.getDialogFont();
        int fontSize = font.getFontData()[0].getHeight();
        Font small = FontDescriptor.createFrom((Font)font).setHeight(fontSize).createFont((Device)parent.getDisplay());
        Composite container = new Composite(parent, 0);
        UI.gl().spacing(0, 3).extendedMargins(10, 0, 10, 0).applyTo(container);
        UI.gdGrabHV().applyTo((Control)container);
        Label header = new Label(container, 64);
        header.setText(Messages.LIST_HEADER_INTERESTED_PROJECTS);
        UI.gdGrabH().hint(preferredWidth, -1).applyTo((Control)header);
        ScrolledComposite scrolledComposite = new ScrolledComposite(container, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        UI.gl().applyTo((Composite)scrolledComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        Composite sections = new Composite((Composite)scrolledComposite, 0);
        UI.gl().extendedMargins(3, 3, 3, 3).applyTo(sections);
        UI.gdGrabHV().hint(preferredWidth, 200).applyTo((Control)scrolledComposite);
        scrolledComposite.setContent((Control)sections);
        Font headlineFont = FontDescriptor.createFrom((Font)font).setStyle(1).createFont((Device)parent.getDisplay());
        for (final IServerDescriptor server : this.servers) {
            Composite section = new Composite(sections, 0);
            int sectionColumns = 5;
            UI.gl().numColumns(sectionColumns).margins(0, 0).spacing(10, 1).applyTo(section);
            UI.gdGrabH().applyTo((Control)section);
            Label icon = new Label(section, 0);
            icon.setImage(server.getImage32());
            UI.gd().indent(0, fontSize / 2).align(1, 1).span(1, 3).applyTo((Control)icon);
            Label headline = new Label(section, 64);
            headline.setText(server.getName());
            headline.setFont(headlineFont);
            UI.gd().span(sectionColumns - 1, 1).applyTo((Control)headline);
            Link description = new Link(section, 64);
            String text = StringUtils.defaultString((String)server.getDescription(), (String)Messages.LINK_TEXT_MISSING_DESCRIPTION);
            description.setText(text);
            description.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Browsers.openInExternalBrowser(e.text);
                }
            });
            UI.gdGrabH().span(sectionColumns - 1, 1).hint(preferredWidth - 10, -1).applyTo((Control)description);
            ILink link = this.getProviderLink(server);
            Hyperlink provider = new Hyperlink(section, 64);
            provider.setText(Formats.format(Messages.LABEL_SERVER_PROVIDER, link.getTitle()));
            provider.setHref((Object)link.getHref());
            provider.setToolTipText(link.getHref());
            provider.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Browsers.openInExternalBrowser(e.getHref());
                }
            });
            provider.setFont(small);
            provider.setUnderlined(true);
            provider.setForeground(parent.getDisplay().getSystemColor(16));
            UI.gdGrabH().align(1, 1).applyTo((Control)provider);
            Link configure = new Link(section, 64);
            configure.setText(Messages.LINK_TEXT_CONFIGURE);
            configure.setFont(small);
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final IEclipseContext child = ServersPage.this.parentContext.createChild();
                    child.set(IServerDescriptor.class, (Object)server);
                    ServersPage.this.uiSynchronize.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialog page = (Dialog)SystemControl.executeHandler(CreateConfigureDialogHandler.class, (IEclipseContext)child);
                            page.open();
                        }
                    });
                }
            });
            UI.gd().align(0x1000008, 0x1000000).applyTo((Control)configure);
            Button enable = new Button(section, 0x800020);
            enable.setFont(parent.getFont());
            BooleanToEnablementTextConverter textConverter = new BooleanToEnablementTextConverter();
            BooleanToEnablementIconConverter iconConverter = new BooleanToEnablementIconConverter();
            Point enabledSize = this.computeSizeForConvertedValue(enable, true, textConverter, iconConverter);
            Point disabledSize = this.computeSizeForConvertedValue(enable, false, textConverter, iconConverter);
            UI.gd().align(0x1000008, 0x1000000).hint(Math.max(enabledSize.x, disabledSize.x), Math.max(enabledSize.y, disabledSize.y)).applyTo((Control)enable);
            ISWTObservableValue swt = WidgetProperties.selection().observe((Widget)enable);
            IObservableValue emf = EMFProperties.value((EStructuralFeature)IIdePackage.Literals.SERVER_DESCRIPTOR__ENABLED).observe((Object)server);
            ISWTObservableValue label = WidgetProperties.text().observe((Widget)enable);
            this.context.bindValue((IObservableValue)swt, emf);
            this.context.bindValue((IObservableValue)label, emf, null, new UpdateValueStrategy().setConverter((IConverter)textConverter));
        }
        Link termsAndConditions = new Link(container, 0);
        termsAndConditions.setText(Messages.LINK_TEXT_ENABLEMENT_ADMONITION);
        UI.gdGrabH().indent(0, 10).align(4, 0x1000008).hint(preferredWidth, -1).applyTo((Control)termsAndConditions);
        Point sectionsSize = sections.computeSize(-1, -1);
        sections.setSize(sectionsSize);
        scrolledComposite.setMinSize(sectionsSize);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private Point computeSizeForConvertedValue(Button button, boolean value, BooleanToEnablementTextConverter textConverter, BooleanToEnablementIconConverter iconConverter) {
        button.setText((String)textConverter.convert(value));
        return button.computeSize(-1, -1, true);
    }

    private ILink getProviderLink(IServerDescriptor server) {
        ILink link = (ILink)server.getLinks().get((Object)"provider");
        if (link == null) {
            return Links.createProviderLink((String)"http://invalid/", (String)Messages.LINK_TOOLTIP_MISSING_URL);
        }
        return link;
    }

    public void dispose() {
        this.context.dispose();
        super.dispose();
    }

    private final class BooleanToEnablementIconConverter
    extends Converter {
        private Image on;
        private Image off;

        private BooleanToEnablementIconConverter() {
            super(Boolean.class, Image.class);
            this.on = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.epp.logging.aeri.ide", (String)"icons/obj16/on.png").createImage();
            this.off = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.epp.logging.aeri.ide", (String)"icons/obj16/off.png").createImage();
        }

        public Object convert(Object fromObject) {
            Boolean value = (Boolean)Objects.firstNonNull((Object)((Boolean)fromObject), (Object)Boolean.FALSE);
            return value != false ? this.on : this.off;
        }
    }

    private final class BooleanToEnablementTextConverter
    extends Converter {
        private BooleanToEnablementTextConverter() {
            super(Boolean.class, String.class);
        }

        public Object convert(Object fromObject) {
            Boolean value = (Boolean)Objects.firstNonNull((Object)((Boolean)fromObject), (Object)Boolean.FALSE);
            return value != false ? Messages.BUTTON_TEXT_ENABLED : Messages.BUTTON_TEXT_DISABLED;
        }
    }
}

