/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmMacroProposalsList;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageBuildProposalsJob;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageProposalsList;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.rpm.ui.editor";
    private static Activator plugin;
    private ContributionTemplateStore fTemplateStore;
    private ContributionContextTypeRegistry fContextTypeRegistry;
    private List<String> rpmGroups = new ArrayList<String>();
    public static RpmPackageProposalsList packagesList;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        RpmPackageBuildProposalsJob.setPropertyChangeListener(true);
        RpmPackageBuildProposalsJob.update(false);
        UiUtils.pluginSanityCheck();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        RpmPackageBuildProposalsJob.setPropertyChangeListener(false);
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), "templates");
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                SpecfileLog.logError(e);
            }
        }
        return this.fTemplateStore;
    }

    public RpmMacroProposalsList getRpmMacroList() {
        return new RpmMacroProposalsList();
    }

    public RpmPackageProposalsList getRpmPackageList() {
        if (packagesList == null || packagesList.getProposals("").size() == 0) {
            packagesList = new RpmPackageProposalsList();
        }
        return packagesList;
    }

    public List<String> getRpmGroups() {
        String docDir;
        File dir;
        if (this.rpmGroups.isEmpty() && (dir = new File(docDir = "/usr/share/doc/")).exists()) {
            File[] files = dir.listFiles((dir1, name) -> name.startsWith("rpm-"));
            try {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    File groupsFile = new File(file, "GROUPS");
                    if (groupsFile.exists()) {
                        try (BufferedReader reader = null;){
                            String line;
                            reader = new LineNumberReader(new FileReader(groupsFile));
                            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                                this.rpmGroups.add(line);
                            }
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                SpecfileLog.logError(e);
            }
        }
        return this.rpmGroups;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.preambleSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.preSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.buildSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.installSection");
            this.fContextTypeRegistry.addContextType("org.eclipse.linuxtools.rpm.ui.editor.changelogSection");
        }
        return this.fContextTypeRegistry;
    }

    public Image getImage(String imageRelativePath) {
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(imageRelativePath);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imageRelativePath);
            registry.put(imageRelativePath, desc);
            image = registry.get(imageRelativePath);
        }
        return image;
    }
}

