/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ByteArrayDefinition;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.ctf.core.CtfEnumPair;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFArrayField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFEnumField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFFloatField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFIntegerArrayField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFIntegerField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFStringField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFStructField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CTFVariantField;
import org.eclipse.tracecompass.tmf.ctf.core.event.Messages;

public abstract class CtfTmfEventField
extends TmfEventField {
    public static final @NonNull String FIELD_VARIANT_SELECTED = "Any";

    protected CtfTmfEventField(@NonNull String name, Object value, ITmfEventField[] fields) {
        super(name.startsWith("_") ? name.substring(1) : name, value, fields);
    }

    @Deprecated
    public static CtfTmfEventField parseField(Definition fieldDef, @NonNull String fieldName) {
        return CtfTmfEventField.parseField((IDefinition)fieldDef, fieldName);
    }

    public static @NonNull CtfTmfEventField parseField(IDefinition fieldDef, @NonNull String fieldName) {
        CtfTmfEventField field = null;
        if (fieldDef instanceof IntegerDefinition) {
            IntegerDefinition intDef = (IntegerDefinition)fieldDef;
            int base = intDef.getDeclaration().getBase();
            field = new CTFIntegerField(fieldName, intDef.getValue(), base, intDef.getDeclaration().isSigned());
        } else if (fieldDef instanceof EnumDefinition) {
            EnumDefinition enumDef = (EnumDefinition)fieldDef;
            field = new CTFEnumField(fieldName, new CtfEnumPair(enumDef.getValue(), enumDef.getIntegerValue()));
        } else if (fieldDef instanceof StringDefinition) {
            field = new CTFStringField(fieldName, ((StringDefinition)fieldDef).getValue());
        } else if (fieldDef instanceof FloatDefinition) {
            FloatDefinition floatDef = (FloatDefinition)fieldDef;
            field = new CTFFloatField(fieldName, floatDef.getValue());
        } else if (fieldDef instanceof AbstractArrayDefinition) {
            AbstractArrayDefinition arrayDef = (AbstractArrayDefinition)fieldDef;
            IDeclaration decl = arrayDef.getDeclaration();
            if (!(decl instanceof CompoundDeclaration)) {
                throw new IllegalArgumentException("Array definitions should only come from sequence or array declarations");
            }
            CompoundDeclaration arrDecl = (CompoundDeclaration)decl;
            IDeclaration elemType = null;
            elemType = arrDecl.getElementType();
            if (elemType instanceof IntegerDeclaration) {
                IntegerDeclaration elemIntType = (IntegerDeclaration)elemType;
                if (elemIntType.isCharacter()) {
                    field = new CTFStringField(fieldName, arrayDef.toString());
                } else if (arrayDef instanceof ByteArrayDefinition) {
                    ByteArrayDefinition byteArrayDefinition = (ByteArrayDefinition)arrayDef;
                    int size = arrayDef.getLength();
                    long[] values = new long[size];
                    int i = 0;
                    while (i < size) {
                        values[i] = Byte.toUnsignedLong(byteArrayDefinition.getByte(i));
                        ++i;
                    }
                    field = new CTFIntegerArrayField(fieldName, values, elemIntType.getBase(), elemIntType.isSigned());
                } else {
                    int size = arrayDef.getLength();
                    long[] values = new long[size];
                    int i = 0;
                    while (i < size) {
                        IDefinition elem = (IDefinition)arrayDef.getDefinitions().get(i);
                        if (elem == null) break;
                        values[i] = ((IntegerDefinition)elem).getValue();
                        ++i;
                    }
                    field = new CTFIntegerArrayField(fieldName, values, elemIntType.getBase(), elemIntType.isSigned());
                }
            } else {
                CtfTmfEventField[] elements = new CtfTmfEventField[arrayDef.getLength()];
                int i = 0;
                List definitions = arrayDef.getDefinitions();
                for (IDefinition definition : definitions) {
                    CtfTmfEventField curField;
                    elements[i] = curField = CtfTmfEventField.parseField(definition, String.valueOf(fieldName) + '[' + i + ']');
                    ++i;
                }
                field = new CTFArrayField(fieldName, elements);
            }
        } else if (fieldDef instanceof ICompositeDefinition) {
            ICompositeDefinition strDef = (ICompositeDefinition)fieldDef;
            ArrayList<CtfTmfEventField> list = new ArrayList<CtfTmfEventField>();
            for (String fn : strDef.getFieldNames()) {
                list.add(CtfTmfEventField.parseField((IDefinition)strDef.getDefinition(fn), fn));
            }
            field = new CTFStructField(fieldName, list.toArray(new CtfTmfEventField[list.size()]));
        } else if (fieldDef instanceof VariantDefinition) {
            VariantDefinition varDef = (VariantDefinition)fieldDef;
            String curFieldName = (String)NonNullUtils.checkNotNull((Object)varDef.getCurrentFieldName());
            Definition curFieldDef = varDef.getCurrentField();
            if (curFieldDef != null) {
                CtfTmfEventField subField = CtfTmfEventField.parseField((IDefinition)curFieldDef, curFieldName);
                field = new CTFVariantField(fieldName, subField);
            } else {
                field = new CTFStringField(curFieldName, "");
            }
        } else {
            field = new CTFStringField(fieldName, String.valueOf(Messages.CtfTmfEventField_UnsupportedType) + fieldDef.getClass().toString());
        }
        return field;
    }

    public String toString() {
        return String.valueOf(this.getName()) + '=' + this.getFormattedValue();
    }
}

