/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.filters;

import com.google.common.base.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.logging.aeri.core.util.StatusSwitch;

public class StatusSizeLimitFilter
implements Predicate<IStatus> {
    private int maxSizeInBytes;

    public StatusSizeLimitFilter(int maxSizeInBytes) {
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public boolean apply(IStatus report) {
        EstimateSizeVisitor visitor = new EstimateSizeVisitor();
        visitor.doSwitch(report);
        int estimatedByteLength = visitor.estimatedCharacters * 2;
        return estimatedByteLength < this.maxSizeInBytes;
    }

    private static final class EstimateSizeVisitor
    extends StatusSwitch<Object> {
        int estimatedCharacters = 0;

        private EstimateSizeVisitor() {
        }

        @Override
        public Object caseStatus(IStatus status) {
            this.estimatedCharacters += StringUtils.defaultString((String)status.getMessage()).length();
            return null;
        }

        @Override
        public Object caseThrowable(Throwable throwable) {
            this.estimatedCharacters += StringUtils.defaultString((String)throwable.getMessage()).length();
            return null;
        }

        @Override
        public Object caseStackTraceElement(StackTraceElement element) {
            this.estimatedCharacters += StringUtils.defaultString((String)element.getClassName()).length();
            this.estimatedCharacters += StringUtils.defaultString((String)element.getFileName()).length();
            this.estimatedCharacters += StringUtils.defaultString((String)element.getMethodName()).length();
            return null;
        }
    }
}

