/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngInterruptContext;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngWorker;

public class LttngSystemModel {
    private final Table<String, Integer, HostThread> fCurrentTids = HashBasedTable.create();
    private final Table<String, Integer, Stack<LttngInterruptContext>> fIntCtxStacks = HashBasedTable.create();
    private final Map<HostThread, LttngWorker> fWorkerMap = new HashMap<HostThread, LttngWorker>();

    public void cacheTidOnCpu(Integer cpu, HostThread ht) {
        this.fCurrentTids.put((Object)ht.getHost(), (Object)cpu, (Object)ht);
    }

    public @Nullable LttngWorker getWorkerOnCpu(String host, Integer cpu) {
        HostThread ht = (HostThread)this.fCurrentTids.get((Object)host, (Object)cpu);
        if (ht == null) {
            return null;
        }
        return this.findWorker(ht);
    }

    public @Nullable LttngWorker findWorker(HostThread ht) {
        return this.fWorkerMap.get(ht);
    }

    public void addWorker(LttngWorker worker) {
        this.fWorkerMap.put(worker.getHostThread(), worker);
    }

    public Collection<LttngWorker> getWorkers() {
        return this.fWorkerMap.values();
    }

    public void pushContextStack(String hostId, Integer cpu, LttngInterruptContext interruptCtx) {
        Stack<LttngInterruptContext> stack = (Stack<LttngInterruptContext>)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            stack = new Stack<LttngInterruptContext>();
            this.fIntCtxStacks.put((Object)hostId, (Object)cpu, stack);
        }
        stack.push(interruptCtx);
    }

    public LttngInterruptContext peekContextStack(String hostId, Integer cpu) {
        Stack stack = (Stack)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            return LttngInterruptContext.DEFAULT_CONTEXT;
        }
        if (stack.empty()) {
            return LttngInterruptContext.DEFAULT_CONTEXT;
        }
        LttngInterruptContext peek = (LttngInterruptContext)stack.peek();
        return peek;
    }

    public @Nullable LttngInterruptContext popContextStack(String hostId, Integer cpu) {
        Stack stack = (Stack)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            return null;
        }
        if (stack.empty()) {
            return null;
        }
        return (LttngInterruptContext)stack.pop();
    }
}

