/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpmstubby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RPMStubbyUtils {
    private DocumentBuilder builder;
    private XPath xPath;
    private static final String PARENT_NODE = "/project/parent";

    public RPMStubbyUtils() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = null;
        try {
            this.builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            StubbyLog.logError(e);
        }
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    public boolean findPom(IPath folderPath) {
        IPath filePath = folderPath.append((IPath)new Path("pom.xml"));
        File file = filePath.toFile();
        boolean rc = false;
        if (file.exists()) {
            try {
                Document xmlDocument = this.builder.parse(new FileInputStream(file));
                String parent = this.xPath.compile(PARENT_NODE).evaluate(xmlDocument);
                rc = !parent.equals("") ? this.findPom(folderPath.removeLastSegments(1)) : true;
            }
            catch (SAXException e) {
                StubbyLog.logError(e);
            }
            catch (IOException e) {
                StubbyLog.logError(e);
            }
            catch (XPathExpressionException e) {
                StubbyLog.logError(e);
            }
        }
        return rc;
    }
}

